/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.PortRange;
import software.amazon.awssdk.services.emr.model.PortRangesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlockPublicAccessConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlockPublicAccessConfiguration> {
    private static final SdkField<Boolean> BLOCK_PUBLIC_SECURITY_GROUP_RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(BlockPublicAccessConfiguration.getter(BlockPublicAccessConfiguration::blockPublicSecurityGroupRules)).setter(BlockPublicAccessConfiguration.setter(Builder::blockPublicSecurityGroupRules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlockPublicSecurityGroupRules").build()}).build();
    private static final SdkField<List<PortRange>> PERMITTED_PUBLIC_SECURITY_GROUP_RULE_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(BlockPublicAccessConfiguration.getter(BlockPublicAccessConfiguration::permittedPublicSecurityGroupRuleRanges)).setter(BlockPublicAccessConfiguration.setter(Builder::permittedPublicSecurityGroupRuleRanges)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermittedPublicSecurityGroupRuleRanges").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BLOCK_PUBLIC_SECURITY_GROUP_RULES_FIELD, PERMITTED_PUBLIC_SECURITY_GROUP_RULE_RANGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean blockPublicSecurityGroupRules;
    private final List<PortRange> permittedPublicSecurityGroupRuleRanges;

    private BlockPublicAccessConfiguration(BuilderImpl builder) {
        this.blockPublicSecurityGroupRules = builder.blockPublicSecurityGroupRules;
        this.permittedPublicSecurityGroupRuleRanges = builder.permittedPublicSecurityGroupRuleRanges;
    }

    public Boolean blockPublicSecurityGroupRules() {
        return this.blockPublicSecurityGroupRules;
    }

    public List<PortRange> permittedPublicSecurityGroupRuleRanges() {
        return this.permittedPublicSecurityGroupRuleRanges;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.blockPublicSecurityGroupRules());
        hashCode = 31 * hashCode + Objects.hashCode(this.permittedPublicSecurityGroupRuleRanges());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockPublicAccessConfiguration)) {
            return false;
        }
        BlockPublicAccessConfiguration other = (BlockPublicAccessConfiguration)obj;
        return Objects.equals(this.blockPublicSecurityGroupRules(), other.blockPublicSecurityGroupRules()) && Objects.equals(this.permittedPublicSecurityGroupRuleRanges(), other.permittedPublicSecurityGroupRuleRanges());
    }

    public String toString() {
        return ToString.builder((String)"BlockPublicAccessConfiguration").add("BlockPublicSecurityGroupRules", (Object)this.blockPublicSecurityGroupRules()).add("PermittedPublicSecurityGroupRuleRanges", this.permittedPublicSecurityGroupRuleRanges()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BlockPublicSecurityGroupRules": {
                return Optional.ofNullable(clazz.cast(this.blockPublicSecurityGroupRules()));
            }
            case "PermittedPublicSecurityGroupRuleRanges": {
                return Optional.ofNullable(clazz.cast(this.permittedPublicSecurityGroupRuleRanges()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlockPublicAccessConfiguration, T> g) {
        return obj -> g.apply((BlockPublicAccessConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean blockPublicSecurityGroupRules;
        private List<PortRange> permittedPublicSecurityGroupRuleRanges = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BlockPublicAccessConfiguration model) {
            this.blockPublicSecurityGroupRules(model.blockPublicSecurityGroupRules);
            this.permittedPublicSecurityGroupRuleRanges(model.permittedPublicSecurityGroupRuleRanges);
        }

        public final Boolean getBlockPublicSecurityGroupRules() {
            return this.blockPublicSecurityGroupRules;
        }

        @Override
        public final Builder blockPublicSecurityGroupRules(Boolean blockPublicSecurityGroupRules) {
            this.blockPublicSecurityGroupRules = blockPublicSecurityGroupRules;
            return this;
        }

        public final void setBlockPublicSecurityGroupRules(Boolean blockPublicSecurityGroupRules) {
            this.blockPublicSecurityGroupRules = blockPublicSecurityGroupRules;
        }

        public final Collection<PortRange.Builder> getPermittedPublicSecurityGroupRuleRanges() {
            return this.permittedPublicSecurityGroupRuleRanges != null ? (Collection)this.permittedPublicSecurityGroupRuleRanges.stream().map(PortRange::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder permittedPublicSecurityGroupRuleRanges(Collection<PortRange> permittedPublicSecurityGroupRuleRanges) {
            this.permittedPublicSecurityGroupRuleRanges = PortRangesCopier.copy(permittedPublicSecurityGroupRuleRanges);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedPublicSecurityGroupRuleRanges(PortRange ... permittedPublicSecurityGroupRuleRanges) {
            this.permittedPublicSecurityGroupRuleRanges(Arrays.asList(permittedPublicSecurityGroupRuleRanges));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permittedPublicSecurityGroupRuleRanges(Consumer<PortRange.Builder> ... permittedPublicSecurityGroupRuleRanges) {
            this.permittedPublicSecurityGroupRuleRanges(Stream.of(permittedPublicSecurityGroupRuleRanges).map(c -> (PortRange)((PortRange.Builder)PortRange.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPermittedPublicSecurityGroupRuleRanges(Collection<PortRange.BuilderImpl> permittedPublicSecurityGroupRuleRanges) {
            this.permittedPublicSecurityGroupRuleRanges = PortRangesCopier.copyFromBuilder(permittedPublicSecurityGroupRuleRanges);
        }

        public BlockPublicAccessConfiguration build() {
            return new BlockPublicAccessConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlockPublicAccessConfiguration> {
        public Builder blockPublicSecurityGroupRules(Boolean var1);

        public Builder permittedPublicSecurityGroupRuleRanges(Collection<PortRange> var1);

        public Builder permittedPublicSecurityGroupRuleRanges(PortRange ... var1);

        public Builder permittedPublicSecurityGroupRuleRanges(Consumer<PortRange.Builder> ... var1);
    }
}

