/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.VolumeSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsBlockDevice
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsBlockDevice> {
    private static final SdkField<VolumeSpecification> VOLUME_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(EbsBlockDevice.getter(EbsBlockDevice::volumeSpecification)).setter(EbsBlockDevice.setter(Builder::volumeSpecification)).constructor(VolumeSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSpecification").build()}).build();
    private static final SdkField<String> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(EbsBlockDevice.getter(EbsBlockDevice::device)).setter(EbsBlockDevice.setter(Builder::device)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_SPECIFICATION_FIELD, DEVICE_FIELD));
    private static final long serialVersionUID = 1L;
    private final VolumeSpecification volumeSpecification;
    private final String device;

    private EbsBlockDevice(BuilderImpl builder) {
        this.volumeSpecification = builder.volumeSpecification;
        this.device = builder.device;
    }

    public VolumeSpecification volumeSpecification() {
        return this.volumeSpecification;
    }

    public String device() {
        return this.device;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDevice)) {
            return false;
        }
        EbsBlockDevice other = (EbsBlockDevice)obj;
        return Objects.equals(this.volumeSpecification(), other.volumeSpecification()) && Objects.equals(this.device(), other.device());
    }

    public String toString() {
        return ToString.builder((String)"EbsBlockDevice").add("VolumeSpecification", (Object)this.volumeSpecification()).add("Device", (Object)this.device()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeSpecification": {
                return Optional.ofNullable(clazz.cast(this.volumeSpecification()));
            }
            case "Device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsBlockDevice, T> g) {
        return obj -> g.apply((EbsBlockDevice)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VolumeSpecification volumeSpecification;
        private String device;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDevice model) {
            this.volumeSpecification(model.volumeSpecification);
            this.device(model.device);
        }

        public final VolumeSpecification.Builder getVolumeSpecification() {
            return this.volumeSpecification != null ? this.volumeSpecification.toBuilder() : null;
        }

        @Override
        public final Builder volumeSpecification(VolumeSpecification volumeSpecification) {
            this.volumeSpecification = volumeSpecification;
            return this;
        }

        public final void setVolumeSpecification(VolumeSpecification.BuilderImpl volumeSpecification) {
            this.volumeSpecification = volumeSpecification != null ? volumeSpecification.build() : null;
        }

        public final String getDevice() {
            return this.device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        public EbsBlockDevice build() {
            return new EbsBlockDevice(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsBlockDevice> {
        public Builder volumeSpecification(VolumeSpecification var1);

        default public Builder volumeSpecification(Consumer<VolumeSpecification.Builder> volumeSpecification) {
            return this.volumeSpecification((VolumeSpecification)((VolumeSpecification.Builder)VolumeSpecification.builder().applyMutation(volumeSpecification)).build());
        }

        public Builder device(String var1);
    }
}

