/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EC2InstanceIdsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceResizePolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceResizePolicy> {
    private static final SdkField<List<String>> INSTANCES_TO_TERMINATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceResizePolicy.getter(InstanceResizePolicy::instancesToTerminate)).setter(InstanceResizePolicy.setter(Builder::instancesToTerminate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToTerminate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> INSTANCES_TO_PROTECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(InstanceResizePolicy.getter(InstanceResizePolicy::instancesToProtect)).setter(InstanceResizePolicy.setter(Builder::instancesToProtect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancesToProtect").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> INSTANCE_TERMINATION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(InstanceResizePolicy.getter(InstanceResizePolicy::instanceTerminationTimeout)).setter(InstanceResizePolicy.setter(Builder::instanceTerminationTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTerminationTimeout").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCES_TO_TERMINATE_FIELD, INSTANCES_TO_PROTECT_FIELD, INSTANCE_TERMINATION_TIMEOUT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> instancesToTerminate;
    private final List<String> instancesToProtect;
    private final Integer instanceTerminationTimeout;

    private InstanceResizePolicy(BuilderImpl builder) {
        this.instancesToTerminate = builder.instancesToTerminate;
        this.instancesToProtect = builder.instancesToProtect;
        this.instanceTerminationTimeout = builder.instanceTerminationTimeout;
    }

    public List<String> instancesToTerminate() {
        return this.instancesToTerminate;
    }

    public List<String> instancesToProtect() {
        return this.instancesToProtect;
    }

    public Integer instanceTerminationTimeout() {
        return this.instanceTerminationTimeout;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesToTerminate());
        hashCode = 31 * hashCode + Objects.hashCode(this.instancesToProtect());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTerminationTimeout());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceResizePolicy)) {
            return false;
        }
        InstanceResizePolicy other = (InstanceResizePolicy)obj;
        return Objects.equals(this.instancesToTerminate(), other.instancesToTerminate()) && Objects.equals(this.instancesToProtect(), other.instancesToProtect()) && Objects.equals(this.instanceTerminationTimeout(), other.instanceTerminationTimeout());
    }

    public String toString() {
        return ToString.builder((String)"InstanceResizePolicy").add("InstancesToTerminate", this.instancesToTerminate()).add("InstancesToProtect", this.instancesToProtect()).add("InstanceTerminationTimeout", (Object)this.instanceTerminationTimeout()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstancesToTerminate": {
                return Optional.ofNullable(clazz.cast(this.instancesToTerminate()));
            }
            case "InstancesToProtect": {
                return Optional.ofNullable(clazz.cast(this.instancesToProtect()));
            }
            case "InstanceTerminationTimeout": {
                return Optional.ofNullable(clazz.cast(this.instanceTerminationTimeout()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceResizePolicy, T> g) {
        return obj -> g.apply((InstanceResizePolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> instancesToTerminate = DefaultSdkAutoConstructList.getInstance();
        private List<String> instancesToProtect = DefaultSdkAutoConstructList.getInstance();
        private Integer instanceTerminationTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceResizePolicy model) {
            this.instancesToTerminate(model.instancesToTerminate);
            this.instancesToProtect(model.instancesToProtect);
            this.instanceTerminationTimeout(model.instanceTerminationTimeout);
        }

        public final Collection<String> getInstancesToTerminate() {
            return this.instancesToTerminate;
        }

        @Override
        public final Builder instancesToTerminate(Collection<String> instancesToTerminate) {
            this.instancesToTerminate = EC2InstanceIdsListCopier.copy(instancesToTerminate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesToTerminate(String ... instancesToTerminate) {
            this.instancesToTerminate(Arrays.asList(instancesToTerminate));
            return this;
        }

        public final void setInstancesToTerminate(Collection<String> instancesToTerminate) {
            this.instancesToTerminate = EC2InstanceIdsListCopier.copy(instancesToTerminate);
        }

        public final Collection<String> getInstancesToProtect() {
            return this.instancesToProtect;
        }

        @Override
        public final Builder instancesToProtect(Collection<String> instancesToProtect) {
            this.instancesToProtect = EC2InstanceIdsListCopier.copy(instancesToProtect);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instancesToProtect(String ... instancesToProtect) {
            this.instancesToProtect(Arrays.asList(instancesToProtect));
            return this;
        }

        public final void setInstancesToProtect(Collection<String> instancesToProtect) {
            this.instancesToProtect = EC2InstanceIdsListCopier.copy(instancesToProtect);
        }

        public final Integer getInstanceTerminationTimeout() {
            return this.instanceTerminationTimeout;
        }

        @Override
        public final Builder instanceTerminationTimeout(Integer instanceTerminationTimeout) {
            this.instanceTerminationTimeout = instanceTerminationTimeout;
            return this;
        }

        public final void setInstanceTerminationTimeout(Integer instanceTerminationTimeout) {
            this.instanceTerminationTimeout = instanceTerminationTimeout;
        }

        public InstanceResizePolicy build() {
            return new InstanceResizePolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceResizePolicy> {
        public Builder instancesToTerminate(Collection<String> var1);

        public Builder instancesToTerminate(String ... var1);

        public Builder instancesToProtect(Collection<String> var1);

        public Builder instancesToProtect(String ... var1);

        public Builder instanceTerminationTimeout(Integer var1);
    }
}

