/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.ScalingAction;
import software.amazon.awssdk.services.emr.model.ScalingTrigger;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScalingRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScalingRule> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ScalingRule.getter(ScalingRule::name)).setter(ScalingRule.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(ScalingRule.getter(ScalingRule::description)).setter(ScalingRule.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<ScalingAction> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Action").getter(ScalingRule.getter(ScalingRule::action)).setter(ScalingRule.setter(Builder::action)).constructor(ScalingAction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<ScalingTrigger> TRIGGER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Trigger").getter(ScalingRule.getter(ScalingRule::trigger)).setter(ScalingRule.setter(Builder::trigger)).constructor(ScalingTrigger::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Trigger").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, ACTION_FIELD, TRIGGER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScalingRule.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final ScalingAction action;
    private final ScalingTrigger trigger;

    private ScalingRule(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.action = builder.action;
        this.trigger = builder.trigger;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final ScalingAction action() {
        return this.action;
    }

    public final ScalingTrigger trigger() {
        return this.trigger;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.trigger());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingRule)) {
            return false;
        }
        ScalingRule other = (ScalingRule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.trigger(), other.trigger());
    }

    public final String toString() {
        return ToString.builder((String)"ScalingRule").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Action", (Object)this.action()).add("Trigger", (Object)this.trigger()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "Trigger": {
                return Optional.ofNullable(clazz.cast(this.trigger()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("Trigger", TRIGGER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScalingRule, T> g) {
        return obj -> g.apply((ScalingRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private ScalingAction action;
        private ScalingTrigger trigger;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingRule model) {
            this.name(model.name);
            this.description(model.description);
            this.action(model.action);
            this.trigger(model.trigger);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final ScalingAction.Builder getAction() {
            return this.action != null ? this.action.toBuilder() : null;
        }

        public final void setAction(ScalingAction.BuilderImpl action) {
            this.action = action != null ? action.build() : null;
        }

        @Override
        public final Builder action(ScalingAction action) {
            this.action = action;
            return this;
        }

        public final ScalingTrigger.Builder getTrigger() {
            return this.trigger != null ? this.trigger.toBuilder() : null;
        }

        public final void setTrigger(ScalingTrigger.BuilderImpl trigger) {
            this.trigger = trigger != null ? trigger.build() : null;
        }

        @Override
        public final Builder trigger(ScalingTrigger trigger) {
            this.trigger = trigger;
            return this;
        }

        public ScalingRule build() {
            return new ScalingRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScalingRule> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder action(ScalingAction var1);

        default public Builder action(Consumer<ScalingAction.Builder> action) {
            return this.action((ScalingAction)((ScalingAction.Builder)ScalingAction.builder().applyMutation(action)).build());
        }

        public Builder trigger(ScalingTrigger var1);

        default public Builder trigger(Consumer<ScalingTrigger.Builder> trigger) {
            return this.trigger((ScalingTrigger)((ScalingTrigger.Builder)ScalingTrigger.builder().applyMutation(trigger)).build());
        }
    }
}

