/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.AutoTerminationPolicy;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAutoTerminationPolicyRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, PutAutoTerminationPolicyRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(PutAutoTerminationPolicyRequest.getter(PutAutoTerminationPolicyRequest::clusterId)).setter(PutAutoTerminationPolicyRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<AutoTerminationPolicy> AUTO_TERMINATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AutoTerminationPolicy").getter(PutAutoTerminationPolicyRequest.getter(PutAutoTerminationPolicyRequest::autoTerminationPolicy)).setter(PutAutoTerminationPolicyRequest.setter(Builder::autoTerminationPolicy)).constructor(AutoTerminationPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoTerminationPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, AUTO_TERMINATION_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAutoTerminationPolicyRequest.memberNameToFieldInitializer();
    private final String clusterId;
    private final AutoTerminationPolicy autoTerminationPolicy;

    private PutAutoTerminationPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.autoTerminationPolicy = builder.autoTerminationPolicy;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final AutoTerminationPolicy autoTerminationPolicy() {
        return this.autoTerminationPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoTerminationPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAutoTerminationPolicyRequest)) {
            return false;
        }
        PutAutoTerminationPolicyRequest other = (PutAutoTerminationPolicyRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.autoTerminationPolicy(), other.autoTerminationPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutAutoTerminationPolicyRequest").add("ClusterId", (Object)this.clusterId()).add("AutoTerminationPolicy", (Object)this.autoTerminationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "AutoTerminationPolicy": {
                return Optional.ofNullable(clazz.cast(this.autoTerminationPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterId", CLUSTER_ID_FIELD);
        map.put("AutoTerminationPolicy", AUTO_TERMINATION_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAutoTerminationPolicyRequest, T> g) {
        return obj -> g.apply((PutAutoTerminationPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private AutoTerminationPolicy autoTerminationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutAutoTerminationPolicyRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.autoTerminationPolicy(model.autoTerminationPolicy);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final AutoTerminationPolicy.Builder getAutoTerminationPolicy() {
            return this.autoTerminationPolicy != null ? this.autoTerminationPolicy.toBuilder() : null;
        }

        public final void setAutoTerminationPolicy(AutoTerminationPolicy.BuilderImpl autoTerminationPolicy) {
            this.autoTerminationPolicy = autoTerminationPolicy != null ? autoTerminationPolicy.build() : null;
        }

        @Override
        public final Builder autoTerminationPolicy(AutoTerminationPolicy autoTerminationPolicy) {
            this.autoTerminationPolicy = autoTerminationPolicy;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutAutoTerminationPolicyRequest build() {
            return new PutAutoTerminationPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAutoTerminationPolicyRequest> {
        public Builder clusterId(String var1);

        public Builder autoTerminationPolicy(AutoTerminationPolicy var1);

        default public Builder autoTerminationPolicy(Consumer<AutoTerminationPolicy.Builder> autoTerminationPolicy) {
            return this.autoTerminationPolicy((AutoTerminationPolicy)((AutoTerminationPolicy.Builder)AutoTerminationPolicy.builder().applyMutation(autoTerminationPolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

