/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse;

public class ListInstanceFleetsIterable
implements SdkIterable<ListInstanceFleetsResponse> {
    private final EmrClient client;
    private final ListInstanceFleetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInstanceFleetsIterable(EmrClient client, ListInstanceFleetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstanceFleetsResponseFetcher();
    }

    public Iterator<ListInstanceFleetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceFleet> instanceFleets() {
        Function<ListInstanceFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceFleets() != null) {
                return response.instanceFleets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private final ListInstanceFleetsIterable resume(ListInstanceFleetsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListInstanceFleetsIterable(this.client, (ListInstanceFleetsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListInstanceFleetsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListInstanceFleetsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListInstanceFleetsResponseFetcher
    implements SyncPageFetcher<ListInstanceFleetsResponse> {
        private ListInstanceFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListInstanceFleetsResponse nextPage(ListInstanceFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceFleetsIterable.this.client.listInstanceFleets(ListInstanceFleetsIterable.this.firstRequest);
            }
            return ListInstanceFleetsIterable.this.client.listInstanceFleets((ListInstanceFleetsRequest)((Object)ListInstanceFleetsIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

