/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.IdentityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateStudioSessionMappingRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, UpdateStudioSessionMappingRequest> {
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StudioId").getter(UpdateStudioSessionMappingRequest.getter(UpdateStudioSessionMappingRequest::studioId)).setter(UpdateStudioSessionMappingRequest.setter(Builder::studioId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioId").build()}).build();
    private static final SdkField<String> IDENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityId").getter(UpdateStudioSessionMappingRequest.getter(UpdateStudioSessionMappingRequest::identityId)).setter(UpdateStudioSessionMappingRequest.setter(Builder::identityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityId").build()}).build();
    private static final SdkField<String> IDENTITY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityName").getter(UpdateStudioSessionMappingRequest.getter(UpdateStudioSessionMappingRequest::identityName)).setter(UpdateStudioSessionMappingRequest.setter(Builder::identityName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityName").build()}).build();
    private static final SdkField<String> IDENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IdentityType").getter(UpdateStudioSessionMappingRequest.getter(UpdateStudioSessionMappingRequest::identityTypeAsString)).setter(UpdateStudioSessionMappingRequest.setter(Builder::identityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdentityType").build()}).build();
    private static final SdkField<String> SESSION_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SessionPolicyArn").getter(UpdateStudioSessionMappingRequest.getter(UpdateStudioSessionMappingRequest::sessionPolicyArn)).setter(UpdateStudioSessionMappingRequest.setter(Builder::sessionPolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionPolicyArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_ID_FIELD, IDENTITY_ID_FIELD, IDENTITY_NAME_FIELD, IDENTITY_TYPE_FIELD, SESSION_POLICY_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateStudioSessionMappingRequest.memberNameToFieldInitializer();
    private final String studioId;
    private final String identityId;
    private final String identityName;
    private final String identityType;
    private final String sessionPolicyArn;

    private UpdateStudioSessionMappingRequest(BuilderImpl builder) {
        super(builder);
        this.studioId = builder.studioId;
        this.identityId = builder.identityId;
        this.identityName = builder.identityName;
        this.identityType = builder.identityType;
        this.sessionPolicyArn = builder.sessionPolicyArn;
    }

    public final String studioId() {
        return this.studioId;
    }

    public final String identityId() {
        return this.identityId;
    }

    public final String identityName() {
        return this.identityName;
    }

    public final IdentityType identityType() {
        return IdentityType.fromValue(this.identityType);
    }

    public final String identityTypeAsString() {
        return this.identityType;
    }

    public final String sessionPolicyArn() {
        return this.sessionPolicyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.studioId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionPolicyArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStudioSessionMappingRequest)) {
            return false;
        }
        UpdateStudioSessionMappingRequest other = (UpdateStudioSessionMappingRequest)((Object)obj);
        return Objects.equals(this.studioId(), other.studioId()) && Objects.equals(this.identityId(), other.identityId()) && Objects.equals(this.identityName(), other.identityName()) && Objects.equals(this.identityTypeAsString(), other.identityTypeAsString()) && Objects.equals(this.sessionPolicyArn(), other.sessionPolicyArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateStudioSessionMappingRequest").add("StudioId", (Object)this.studioId()).add("IdentityId", (Object)this.identityId()).add("IdentityName", (Object)this.identityName()).add("IdentityType", (Object)this.identityTypeAsString()).add("SessionPolicyArn", (Object)this.sessionPolicyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StudioId": {
                return Optional.ofNullable(clazz.cast(this.studioId()));
            }
            case "IdentityId": {
                return Optional.ofNullable(clazz.cast(this.identityId()));
            }
            case "IdentityName": {
                return Optional.ofNullable(clazz.cast(this.identityName()));
            }
            case "IdentityType": {
                return Optional.ofNullable(clazz.cast(this.identityTypeAsString()));
            }
            case "SessionPolicyArn": {
                return Optional.ofNullable(clazz.cast(this.sessionPolicyArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("StudioId", STUDIO_ID_FIELD);
        map.put("IdentityId", IDENTITY_ID_FIELD);
        map.put("IdentityName", IDENTITY_NAME_FIELD);
        map.put("IdentityType", IDENTITY_TYPE_FIELD);
        map.put("SessionPolicyArn", SESSION_POLICY_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateStudioSessionMappingRequest, T> g) {
        return obj -> g.apply((UpdateStudioSessionMappingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String studioId;
        private String identityId;
        private String identityName;
        private String identityType;
        private String sessionPolicyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateStudioSessionMappingRequest model) {
            super(model);
            this.studioId(model.studioId);
            this.identityId(model.identityId);
            this.identityName(model.identityName);
            this.identityType(model.identityType);
            this.sessionPolicyArn(model.sessionPolicyArn);
        }

        public final String getStudioId() {
            return this.studioId;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final String getIdentityId() {
            return this.identityId;
        }

        public final void setIdentityId(String identityId) {
            this.identityId = identityId;
        }

        @Override
        public final Builder identityId(String identityId) {
            this.identityId = identityId;
            return this;
        }

        public final String getIdentityName() {
            return this.identityName;
        }

        public final void setIdentityName(String identityName) {
            this.identityName = identityName;
        }

        @Override
        public final Builder identityName(String identityName) {
            this.identityName = identityName;
            return this;
        }

        public final String getIdentityType() {
            return this.identityType;
        }

        public final void setIdentityType(String identityType) {
            this.identityType = identityType;
        }

        @Override
        public final Builder identityType(String identityType) {
            this.identityType = identityType;
            return this;
        }

        @Override
        public final Builder identityType(IdentityType identityType) {
            this.identityType(identityType == null ? null : identityType.toString());
            return this;
        }

        public final String getSessionPolicyArn() {
            return this.sessionPolicyArn;
        }

        public final void setSessionPolicyArn(String sessionPolicyArn) {
            this.sessionPolicyArn = sessionPolicyArn;
        }

        @Override
        public final Builder sessionPolicyArn(String sessionPolicyArn) {
            this.sessionPolicyArn = sessionPolicyArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateStudioSessionMappingRequest build() {
            return new UpdateStudioSessionMappingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateStudioSessionMappingRequest> {
        public Builder studioId(String var1);

        public Builder identityId(String var1);

        public Builder identityName(String var1);

        public Builder identityType(String var1);

        public Builder identityType(IdentityType var1);

        public Builder sessionPolicyArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

