/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.InstanceFleetType;
import software.amazon.awssdk.services.emr.model.InstanceGroupType;
import software.amazon.awssdk.services.emr.model.InstanceGroupTypeListCopier;
import software.amazon.awssdk.services.emr.model.InstanceState;
import software.amazon.awssdk.services.emr.model.InstanceStateListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInstancesRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, ListInstancesRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(ListInstancesRequest.getter(ListInstancesRequest::clusterId)).setter(ListInstancesRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupId").getter(ListInstancesRequest.getter(ListInstancesRequest::instanceGroupId)).setter(ListInstancesRequest.setter(Builder::instanceGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupId").build()}).build();
    private static final SdkField<List<String>> INSTANCE_GROUP_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceGroupTypes").getter(ListInstancesRequest.getter(ListInstancesRequest::instanceGroupTypesAsStrings)).setter(ListInstancesRequest.setter(Builder::instanceGroupTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFleetId").getter(ListInstancesRequest.getter(ListInstancesRequest::instanceFleetId)).setter(ListInstancesRequest.setter(Builder::instanceFleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetId").build()}).build();
    private static final SdkField<String> INSTANCE_FLEET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceFleetType").getter(ListInstancesRequest.getter(ListInstancesRequest::instanceFleetTypeAsString)).setter(ListInstancesRequest.setter(Builder::instanceFleetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetType").build()}).build();
    private static final SdkField<List<String>> INSTANCE_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceStates").getter(ListInstancesRequest.getter(ListInstancesRequest::instanceStatesAsStrings)).setter(ListInstancesRequest.setter(Builder::instanceStatesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListInstancesRequest.getter(ListInstancesRequest::marker)).setter(ListInstancesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, INSTANCE_GROUP_ID_FIELD, INSTANCE_GROUP_TYPES_FIELD, INSTANCE_FLEET_ID_FIELD, INSTANCE_FLEET_TYPE_FIELD, INSTANCE_STATES_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClusterId", CLUSTER_ID_FIELD);
            this.put("InstanceGroupId", INSTANCE_GROUP_ID_FIELD);
            this.put("InstanceGroupTypes", INSTANCE_GROUP_TYPES_FIELD);
            this.put("InstanceFleetId", INSTANCE_FLEET_ID_FIELD);
            this.put("InstanceFleetType", INSTANCE_FLEET_TYPE_FIELD);
            this.put("InstanceStates", INSTANCE_STATES_FIELD);
            this.put("Marker", MARKER_FIELD);
        }
    });
    private final String clusterId;
    private final String instanceGroupId;
    private final List<String> instanceGroupTypes;
    private final String instanceFleetId;
    private final String instanceFleetType;
    private final List<String> instanceStates;
    private final String marker;

    private ListInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceGroupId = builder.instanceGroupId;
        this.instanceGroupTypes = builder.instanceGroupTypes;
        this.instanceFleetId = builder.instanceFleetId;
        this.instanceFleetType = builder.instanceFleetType;
        this.instanceStates = builder.instanceStates;
        this.marker = builder.marker;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final String instanceGroupId() {
        return this.instanceGroupId;
    }

    public final List<InstanceGroupType> instanceGroupTypes() {
        return InstanceGroupTypeListCopier.copyStringToEnum(this.instanceGroupTypes);
    }

    public final boolean hasInstanceGroupTypes() {
        return this.instanceGroupTypes != null && !(this.instanceGroupTypes instanceof SdkAutoConstructList);
    }

    public final List<String> instanceGroupTypesAsStrings() {
        return this.instanceGroupTypes;
    }

    public final String instanceFleetId() {
        return this.instanceFleetId;
    }

    public final InstanceFleetType instanceFleetType() {
        return InstanceFleetType.fromValue(this.instanceFleetType);
    }

    public final String instanceFleetTypeAsString() {
        return this.instanceFleetType;
    }

    public final List<InstanceState> instanceStates() {
        return InstanceStateListCopier.copyStringToEnum(this.instanceStates);
    }

    public final boolean hasInstanceStates() {
        return this.instanceStates != null && !(this.instanceStates instanceof SdkAutoConstructList);
    }

    public final List<String> instanceStatesAsStrings() {
        return this.instanceStates;
    }

    public final String marker() {
        return this.marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceGroupTypes() ? this.instanceGroupTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceStates() ? this.instanceStatesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstancesRequest)) {
            return false;
        }
        ListInstancesRequest other = (ListInstancesRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && this.hasInstanceGroupTypes() == other.hasInstanceGroupTypes() && Objects.equals(this.instanceGroupTypesAsStrings(), other.instanceGroupTypesAsStrings()) && Objects.equals(this.instanceFleetId(), other.instanceFleetId()) && Objects.equals(this.instanceFleetTypeAsString(), other.instanceFleetTypeAsString()) && this.hasInstanceStates() == other.hasInstanceStates() && Objects.equals(this.instanceStatesAsStrings(), other.instanceStatesAsStrings()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"ListInstancesRequest").add("ClusterId", (Object)this.clusterId()).add("InstanceGroupId", (Object)this.instanceGroupId()).add("InstanceGroupTypes", this.hasInstanceGroupTypes() ? this.instanceGroupTypesAsStrings() : null).add("InstanceFleetId", (Object)this.instanceFleetId()).add("InstanceFleetType", (Object)this.instanceFleetTypeAsString()).add("InstanceStates", this.hasInstanceStates() ? this.instanceStatesAsStrings() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "InstanceGroupId": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupId()));
            }
            case "InstanceGroupTypes": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupTypesAsStrings()));
            }
            case "InstanceFleetId": {
                return Optional.ofNullable(clazz.cast(this.instanceFleetId()));
            }
            case "InstanceFleetType": {
                return Optional.ofNullable(clazz.cast(this.instanceFleetTypeAsString()));
            }
            case "InstanceStates": {
                return Optional.ofNullable(clazz.cast(this.instanceStatesAsStrings()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListInstancesRequest, T> g) {
        return obj -> g.apply((ListInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private String instanceGroupId;
        private List<String> instanceGroupTypes = DefaultSdkAutoConstructList.getInstance();
        private String instanceFleetId;
        private String instanceFleetType;
        private List<String> instanceStates = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstancesRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.instanceGroupId(model.instanceGroupId);
            this.instanceGroupTypesWithStrings(model.instanceGroupTypes);
            this.instanceFleetId(model.instanceFleetId);
            this.instanceFleetType(model.instanceFleetType);
            this.instanceStatesWithStrings(model.instanceStates);
            this.marker(model.marker);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final Collection<String> getInstanceGroupTypes() {
            if (this.instanceGroupTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceGroupTypes;
        }

        public final void setInstanceGroupTypes(Collection<String> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copy(instanceGroupTypes);
        }

        @Override
        public final Builder instanceGroupTypesWithStrings(Collection<String> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copy(instanceGroupTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupTypesWithStrings(String ... instanceGroupTypes) {
            this.instanceGroupTypesWithStrings(Arrays.asList(instanceGroupTypes));
            return this;
        }

        @Override
        public final Builder instanceGroupTypes(Collection<InstanceGroupType> instanceGroupTypes) {
            this.instanceGroupTypes = InstanceGroupTypeListCopier.copyEnumToString(instanceGroupTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupTypes(InstanceGroupType ... instanceGroupTypes) {
            this.instanceGroupTypes(Arrays.asList(instanceGroupTypes));
            return this;
        }

        public final String getInstanceFleetId() {
            return this.instanceFleetId;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final String getInstanceFleetType() {
            return this.instanceFleetType;
        }

        public final void setInstanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
        }

        @Override
        public final Builder instanceFleetType(String instanceFleetType) {
            this.instanceFleetType = instanceFleetType;
            return this;
        }

        @Override
        public final Builder instanceFleetType(InstanceFleetType instanceFleetType) {
            this.instanceFleetType(instanceFleetType == null ? null : instanceFleetType.toString());
            return this;
        }

        public final Collection<String> getInstanceStates() {
            if (this.instanceStates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.instanceStates;
        }

        public final void setInstanceStates(Collection<String> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copy(instanceStates);
        }

        @Override
        public final Builder instanceStatesWithStrings(Collection<String> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copy(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStatesWithStrings(String ... instanceStates) {
            this.instanceStatesWithStrings(Arrays.asList(instanceStates));
            return this;
        }

        @Override
        public final Builder instanceStates(Collection<InstanceState> instanceStates) {
            this.instanceStates = InstanceStateListCopier.copyEnumToString(instanceStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStates(InstanceState ... instanceStates) {
            this.instanceStates(Arrays.asList(instanceStates));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInstancesRequest build() {
            return new ListInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInstancesRequest> {
        public Builder clusterId(String var1);

        public Builder instanceGroupId(String var1);

        public Builder instanceGroupTypesWithStrings(Collection<String> var1);

        public Builder instanceGroupTypesWithStrings(String ... var1);

        public Builder instanceGroupTypes(Collection<InstanceGroupType> var1);

        public Builder instanceGroupTypes(InstanceGroupType ... var1);

        public Builder instanceFleetId(String var1);

        public Builder instanceFleetType(String var1);

        public Builder instanceFleetType(InstanceFleetType var1);

        public Builder instanceStatesWithStrings(Collection<String> var1);

        public Builder instanceStatesWithStrings(String ... var1);

        public Builder instanceStates(Collection<InstanceState> var1);

        public Builder instanceStates(InstanceState ... var1);

        public Builder marker(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

