/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.emr.EmrClient;
import software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesRequest;
import software.amazon.awssdk.services.emr.model.ListSupportedInstanceTypesResponse;

public class ListSupportedInstanceTypesIterable
implements SdkIterable<ListSupportedInstanceTypesResponse> {
    private final EmrClient client;
    private final ListSupportedInstanceTypesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSupportedInstanceTypesIterable(EmrClient client, ListSupportedInstanceTypesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListSupportedInstanceTypesResponseFetcher();
    }

    public Iterator<ListSupportedInstanceTypesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListSupportedInstanceTypesResponseFetcher
    implements SyncPageFetcher<ListSupportedInstanceTypesResponse> {
        private ListSupportedInstanceTypesResponseFetcher() {
        }

        public boolean hasNextPage(ListSupportedInstanceTypesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public ListSupportedInstanceTypesResponse nextPage(ListSupportedInstanceTypesResponse previousPage) {
            if (previousPage == null) {
                return ListSupportedInstanceTypesIterable.this.client.listSupportedInstanceTypes(ListSupportedInstanceTypesIterable.this.firstRequest);
            }
            return ListSupportedInstanceTypesIterable.this.client.listSupportedInstanceTypes((ListSupportedInstanceTypesRequest)((Object)ListSupportedInstanceTypesIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

