/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EbsVolume
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EbsVolume> {
    private static final SdkField<String> DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Device").getter(EbsVolume.getter(EbsVolume::device)).setter(EbsVolume.setter(Builder::device)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").build()}).build();
    private static final SdkField<String> VOLUME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeId").getter(EbsVolume.getter(EbsVolume::volumeId)).setter(EbsVolume.setter(Builder::volumeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_FIELD, VOLUME_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String device;
    private final String volumeId;

    private EbsVolume(BuilderImpl builder) {
        this.device = builder.device;
        this.volumeId = builder.volumeId;
    }

    public final String device() {
        return this.device;
    }

    public final String volumeId() {
        return this.volumeId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.device());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsVolume)) {
            return false;
        }
        EbsVolume other = (EbsVolume)obj;
        return Objects.equals(this.device(), other.device()) && Objects.equals(this.volumeId(), other.volumeId());
    }

    public final String toString() {
        return ToString.builder((String)"EbsVolume").add("Device", (Object)this.device()).add("VolumeId", (Object)this.volumeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Device": {
                return Optional.ofNullable(clazz.cast(this.device()));
            }
            case "VolumeId": {
                return Optional.ofNullable(clazz.cast(this.volumeId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsVolume, T> g) {
        return obj -> g.apply((EbsVolume)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String device;
        private String volumeId;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsVolume model) {
            this.device(model.device);
            this.volumeId(model.volumeId);
        }

        public final String getDevice() {
            return this.device;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public EbsVolume build() {
            return new EbsVolume(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EbsVolume> {
        public Builder device(String var1);

        public Builder volumeId(String var1);
    }
}

