/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon EBS configuration of a cluster instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsConfiguration.Builder, EbsConfiguration> {
    private static final SdkField<List<EbsBlockDeviceConfig>> EBS_BLOCK_DEVICE_CONFIGS_FIELD = SdkField
            .<List<EbsBlockDeviceConfig>> builder(MarshallingType.LIST)
            .memberName("EbsBlockDeviceConfigs")
            .getter(getter(EbsConfiguration::ebsBlockDeviceConfigs))
            .setter(setter(Builder::ebsBlockDeviceConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsBlockDeviceConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EbsBlockDeviceConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EbsBlockDeviceConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized").getter(getter(EbsConfiguration::ebsOptimized)).setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EBS_BLOCK_DEVICE_CONFIGS_FIELD, EBS_OPTIMIZED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs;

    private final Boolean ebsOptimized;

    private EbsConfiguration(BuilderImpl builder) {
        this.ebsBlockDeviceConfigs = builder.ebsBlockDeviceConfigs;
        this.ebsOptimized = builder.ebsOptimized;
    }

    /**
     * For responses, this returns true if the service returned a value for the EbsBlockDeviceConfigs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEbsBlockDeviceConfigs() {
        return ebsBlockDeviceConfigs != null && !(ebsBlockDeviceConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon EBS volume specifications attached to a cluster instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEbsBlockDeviceConfigs} method.
     * </p>
     * 
     * @return An array of Amazon EBS volume specifications attached to a cluster instance.
     */
    public final List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs() {
        return ebsBlockDeviceConfigs;
    }

    /**
     * <p>
     * Indicates whether an Amazon EBS volume is EBS-optimized.
     * </p>
     * 
     * @return Indicates whether an Amazon EBS volume is EBS-optimized.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasEbsBlockDeviceConfigs() ? ebsBlockDeviceConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsConfiguration)) {
            return false;
        }
        EbsConfiguration other = (EbsConfiguration) obj;
        return hasEbsBlockDeviceConfigs() == other.hasEbsBlockDeviceConfigs()
                && Objects.equals(ebsBlockDeviceConfigs(), other.ebsBlockDeviceConfigs())
                && Objects.equals(ebsOptimized(), other.ebsOptimized());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EbsConfiguration")
                .add("EbsBlockDeviceConfigs", hasEbsBlockDeviceConfigs() ? ebsBlockDeviceConfigs() : null)
                .add("EbsOptimized", ebsOptimized()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsBlockDeviceConfigs":
            return Optional.ofNullable(clazz.cast(ebsBlockDeviceConfigs()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsConfiguration, T> g) {
        return obj -> g.apply((EbsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsConfiguration> {
        /**
         * <p>
         * An array of Amazon EBS volume specifications attached to a cluster instance.
         * </p>
         * 
         * @param ebsBlockDeviceConfigs
         *        An array of Amazon EBS volume specifications attached to a cluster instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> ebsBlockDeviceConfigs);

        /**
         * <p>
         * An array of Amazon EBS volume specifications attached to a cluster instance.
         * </p>
         * 
         * @param ebsBlockDeviceConfigs
         *        An array of Amazon EBS volume specifications attached to a cluster instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsBlockDeviceConfigs(EbsBlockDeviceConfig... ebsBlockDeviceConfigs);

        /**
         * <p>
         * An array of Amazon EBS volume specifications attached to a cluster instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #ebsBlockDeviceConfigs(List<EbsBlockDeviceConfig>)}.
         * 
         * @param ebsBlockDeviceConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsBlockDeviceConfigs(java.util.Collection<EbsBlockDeviceConfig>)
         */
        Builder ebsBlockDeviceConfigs(Consumer<EbsBlockDeviceConfig.Builder>... ebsBlockDeviceConfigs);

        /**
         * <p>
         * Indicates whether an Amazon EBS volume is EBS-optimized.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether an Amazon EBS volume is EBS-optimized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);
    }

    static final class BuilderImpl implements Builder {
        private List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs = DefaultSdkAutoConstructList.getInstance();

        private Boolean ebsOptimized;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsConfiguration model) {
            ebsBlockDeviceConfigs(model.ebsBlockDeviceConfigs);
            ebsOptimized(model.ebsOptimized);
        }

        public final List<EbsBlockDeviceConfig.Builder> getEbsBlockDeviceConfigs() {
            List<EbsBlockDeviceConfig.Builder> result = EbsBlockDeviceConfigListCopier.copyToBuilder(this.ebsBlockDeviceConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEbsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig.BuilderImpl> ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs = EbsBlockDeviceConfigListCopier.copyFromBuilder(ebsBlockDeviceConfigs);
        }

        @Override
        public final Builder ebsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs = EbsBlockDeviceConfigListCopier.copy(ebsBlockDeviceConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDeviceConfigs(EbsBlockDeviceConfig... ebsBlockDeviceConfigs) {
            ebsBlockDeviceConfigs(Arrays.asList(ebsBlockDeviceConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDeviceConfigs(Consumer<EbsBlockDeviceConfig.Builder>... ebsBlockDeviceConfigs) {
            ebsBlockDeviceConfigs(Stream.of(ebsBlockDeviceConfigs)
                    .map(c -> EbsBlockDeviceConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        @Override
        public EbsConfiguration build() {
            return new EbsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
