/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The launch specification for Spot Instances in the fleet, which determines the defined duration, provisioning timeout
 * behavior, and allocation strategy.
 * </p>
 * <note>
 * <p>
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 * On-Demand and Spot instance allocation strategies are available in Amazon EMR version 5.12.1 and later.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceFleetProvisioningSpecifications implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceFleetProvisioningSpecifications.Builder, InstanceFleetProvisioningSpecifications> {
    private static final SdkField<SpotProvisioningSpecification> SPOT_SPECIFICATION_FIELD = SdkField
            .<SpotProvisioningSpecification> builder(MarshallingType.SDK_POJO).memberName("SpotSpecification")
            .getter(getter(InstanceFleetProvisioningSpecifications::spotSpecification))
            .setter(setter(Builder::spotSpecification)).constructor(SpotProvisioningSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpotSpecification").build()).build();

    private static final SdkField<OnDemandProvisioningSpecification> ON_DEMAND_SPECIFICATION_FIELD = SdkField
            .<OnDemandProvisioningSpecification> builder(MarshallingType.SDK_POJO).memberName("OnDemandSpecification")
            .getter(getter(InstanceFleetProvisioningSpecifications::onDemandSpecification))
            .setter(setter(Builder::onDemandSpecification)).constructor(OnDemandProvisioningSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnDemandSpecification").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SPOT_SPECIFICATION_FIELD,
            ON_DEMAND_SPECIFICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final SpotProvisioningSpecification spotSpecification;

    private final OnDemandProvisioningSpecification onDemandSpecification;

    private InstanceFleetProvisioningSpecifications(BuilderImpl builder) {
        this.spotSpecification = builder.spotSpecification;
        this.onDemandSpecification = builder.onDemandSpecification;
    }

    /**
     * <p>
     * The launch specification for Spot instances in the fleet, which determines the defined duration, provisioning
     * timeout behavior, and allocation strategy.
     * </p>
     * 
     * @return The launch specification for Spot instances in the fleet, which determines the defined duration,
     *         provisioning timeout behavior, and allocation strategy.
     */
    public final SpotProvisioningSpecification spotSpecification() {
        return spotSpecification;
    }

    /**
     * <p>
     * The launch specification for On-Demand Instances in the instance fleet, which determines the allocation strategy.
     * </p>
     * <note>
     * <p>
     * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
     * versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and later.
     * </p>
     * </note>
     * 
     * @return The launch specification for On-Demand Instances in the instance fleet, which determines the allocation
     *         strategy. </p> <note>
     *         <p>
     *         The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding
     *         5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and
     *         later.
     *         </p>
     */
    public final OnDemandProvisioningSpecification onDemandSpecification() {
        return onDemandSpecification;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(spotSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(onDemandSpecification());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetProvisioningSpecifications)) {
            return false;
        }
        InstanceFleetProvisioningSpecifications other = (InstanceFleetProvisioningSpecifications) obj;
        return Objects.equals(spotSpecification(), other.spotSpecification())
                && Objects.equals(onDemandSpecification(), other.onDemandSpecification());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceFleetProvisioningSpecifications").add("SpotSpecification", spotSpecification())
                .add("OnDemandSpecification", onDemandSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SpotSpecification":
            return Optional.ofNullable(clazz.cast(spotSpecification()));
        case "OnDemandSpecification":
            return Optional.ofNullable(clazz.cast(onDemandSpecification()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetProvisioningSpecifications, T> g) {
        return obj -> g.apply((InstanceFleetProvisioningSpecifications) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceFleetProvisioningSpecifications> {
        /**
         * <p>
         * The launch specification for Spot instances in the fleet, which determines the defined duration, provisioning
         * timeout behavior, and allocation strategy.
         * </p>
         * 
         * @param spotSpecification
         *        The launch specification for Spot instances in the fleet, which determines the defined duration,
         *        provisioning timeout behavior, and allocation strategy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spotSpecification(SpotProvisioningSpecification spotSpecification);

        /**
         * <p>
         * The launch specification for Spot instances in the fleet, which determines the defined duration, provisioning
         * timeout behavior, and allocation strategy.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpotProvisioningSpecification.Builder}
         * avoiding the need to create one manually via {@link SpotProvisioningSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpotProvisioningSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #spotSpecification(SpotProvisioningSpecification)}.
         * 
         * @param spotSpecification
         *        a consumer that will call methods on {@link SpotProvisioningSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spotSpecification(SpotProvisioningSpecification)
         */
        default Builder spotSpecification(Consumer<SpotProvisioningSpecification.Builder> spotSpecification) {
            return spotSpecification(SpotProvisioningSpecification.builder().applyMutation(spotSpecification).build());
        }

        /**
         * <p>
         * The launch specification for On-Demand Instances in the instance fleet, which determines the allocation
         * strategy.
         * </p>
         * <note>
         * <p>
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
         * versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and later.
         * </p>
         * </note>
         * 
         * @param onDemandSpecification
         *        The launch specification for On-Demand Instances in the instance fleet, which determines the
         *        allocation strategy. </p> <note>
         *        <p>
         *        The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding
         *        5.0.x versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and
         *        later.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onDemandSpecification(OnDemandProvisioningSpecification onDemandSpecification);

        /**
         * <p>
         * The launch specification for On-Demand Instances in the instance fleet, which determines the allocation
         * strategy.
         * </p>
         * <note>
         * <p>
         * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x
         * versions. On-Demand Instances allocation strategy is available in Amazon EMR version 5.12.1 and later.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link OnDemandProvisioningSpecification.Builder} avoiding the need to create one manually via
         * {@link OnDemandProvisioningSpecification#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OnDemandProvisioningSpecification.Builder#build()} is called
         * immediately and its result is passed to {@link #onDemandSpecification(OnDemandProvisioningSpecification)}.
         * 
         * @param onDemandSpecification
         *        a consumer that will call methods on {@link OnDemandProvisioningSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #onDemandSpecification(OnDemandProvisioningSpecification)
         */
        default Builder onDemandSpecification(Consumer<OnDemandProvisioningSpecification.Builder> onDemandSpecification) {
            return onDemandSpecification(OnDemandProvisioningSpecification.builder().applyMutation(onDemandSpecification).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SpotProvisioningSpecification spotSpecification;

        private OnDemandProvisioningSpecification onDemandSpecification;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetProvisioningSpecifications model) {
            spotSpecification(model.spotSpecification);
            onDemandSpecification(model.onDemandSpecification);
        }

        public final SpotProvisioningSpecification.Builder getSpotSpecification() {
            return spotSpecification != null ? spotSpecification.toBuilder() : null;
        }

        public final void setSpotSpecification(SpotProvisioningSpecification.BuilderImpl spotSpecification) {
            this.spotSpecification = spotSpecification != null ? spotSpecification.build() : null;
        }

        @Override
        public final Builder spotSpecification(SpotProvisioningSpecification spotSpecification) {
            this.spotSpecification = spotSpecification;
            return this;
        }

        public final OnDemandProvisioningSpecification.Builder getOnDemandSpecification() {
            return onDemandSpecification != null ? onDemandSpecification.toBuilder() : null;
        }

        public final void setOnDemandSpecification(OnDemandProvisioningSpecification.BuilderImpl onDemandSpecification) {
            this.onDemandSpecification = onDemandSpecification != null ? onDemandSpecification.build() : null;
        }

        @Override
        public final Builder onDemandSpecification(OnDemandProvisioningSpecification onDemandSpecification) {
            this.onDemandSpecification = onDemandSpecification;
            return this;
        }

        @Override
        public InstanceFleetProvisioningSpecifications build() {
            return new InstanceFleetProvisioningSpecifications(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
