/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The release label filters by application or version prefix.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReleaseLabelFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ReleaseLabelFilter.Builder, ReleaseLabelFilter> {
    private static final SdkField<String> PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Prefix")
            .getter(getter(ReleaseLabelFilter::prefix)).setter(setter(Builder::prefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Prefix").build()).build();

    private static final SdkField<String> APPLICATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Application").getter(getter(ReleaseLabelFilter::application)).setter(setter(Builder::application))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Application").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFIX_FIELD,
            APPLICATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String prefix;

    private final String application;

    private ReleaseLabelFilter(BuilderImpl builder) {
        this.prefix = builder.prefix;
        this.application = builder.application;
    }

    /**
     * <p>
     * Optional release label version prefix filter. For example, <code>emr-5</code>.
     * </p>
     * 
     * @return Optional release label version prefix filter. For example, <code>emr-5</code>.
     */
    public final String prefix() {
        return prefix;
    }

    /**
     * <p>
     * Optional release label application filter. For example, <code>spark@2.1.0</code>.
     * </p>
     * 
     * @return Optional release label application filter. For example, <code>spark@2.1.0</code>.
     */
    public final String application() {
        return application;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(prefix());
        hashCode = 31 * hashCode + Objects.hashCode(application());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseLabelFilter)) {
            return false;
        }
        ReleaseLabelFilter other = (ReleaseLabelFilter) obj;
        return Objects.equals(prefix(), other.prefix()) && Objects.equals(application(), other.application());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReleaseLabelFilter").add("Prefix", prefix()).add("Application", application()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Prefix":
            return Optional.ofNullable(clazz.cast(prefix()));
        case "Application":
            return Optional.ofNullable(clazz.cast(application()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReleaseLabelFilter, T> g) {
        return obj -> g.apply((ReleaseLabelFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReleaseLabelFilter> {
        /**
         * <p>
         * Optional release label version prefix filter. For example, <code>emr-5</code>.
         * </p>
         * 
         * @param prefix
         *        Optional release label version prefix filter. For example, <code>emr-5</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder prefix(String prefix);

        /**
         * <p>
         * Optional release label application filter. For example, <code>spark@2.1.0</code>.
         * </p>
         * 
         * @param application
         *        Optional release label application filter. For example, <code>spark@2.1.0</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder application(String application);
    }

    static final class BuilderImpl implements Builder {
        private String prefix;

        private String application;

        private BuilderImpl() {
        }

        private BuilderImpl(ReleaseLabelFilter model) {
            prefix(model.prefix);
            application(model.application);
        }

        public final String getPrefix() {
            return prefix;
        }

        public final void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public final Builder prefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public final String getApplication() {
            return application;
        }

        public final void setApplication(String application) {
            this.application = application;
        }

        @Override
        public final Builder application(String application) {
            this.application = application;
            return this;
        }

        @Override
        public ReleaseLabelFilter build() {
            return new ReleaseLabelFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
