/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.EmrRequest;
import software.amazon.awssdk.services.emr.model.ManagedScalingPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutManagedScalingPolicyRequest
extends EmrRequest
implements ToCopyableBuilder<Builder, PutManagedScalingPolicyRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterId").getter(PutManagedScalingPolicyRequest.getter(PutManagedScalingPolicyRequest::clusterId)).setter(PutManagedScalingPolicyRequest.setter(Builder::clusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()}).build();
    private static final SdkField<ManagedScalingPolicy> MANAGED_SCALING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ManagedScalingPolicy").getter(PutManagedScalingPolicyRequest.getter(PutManagedScalingPolicyRequest::managedScalingPolicy)).setter(PutManagedScalingPolicyRequest.setter(Builder::managedScalingPolicy)).constructor(ManagedScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedScalingPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD, MANAGED_SCALING_POLICY_FIELD));
    private final String clusterId;
    private final ManagedScalingPolicy managedScalingPolicy;

    private PutManagedScalingPolicyRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.managedScalingPolicy = builder.managedScalingPolicy;
    }

    public final String clusterId() {
        return this.clusterId;
    }

    public final ManagedScalingPolicy managedScalingPolicy() {
        return this.managedScalingPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedScalingPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutManagedScalingPolicyRequest)) {
            return false;
        }
        PutManagedScalingPolicyRequest other = (PutManagedScalingPolicyRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.managedScalingPolicy(), other.managedScalingPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"PutManagedScalingPolicyRequest").add("ClusterId", (Object)this.clusterId()).add("ManagedScalingPolicy", (Object)this.managedScalingPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.ofNullable(clazz.cast(this.clusterId()));
            }
            case "ManagedScalingPolicy": {
                return Optional.ofNullable(clazz.cast(this.managedScalingPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutManagedScalingPolicyRequest, T> g) {
        return obj -> g.apply((PutManagedScalingPolicyRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EmrRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private ManagedScalingPolicy managedScalingPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(PutManagedScalingPolicyRequest model) {
            super(model);
            this.clusterId(model.clusterId);
            this.managedScalingPolicy(model.managedScalingPolicy);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final ManagedScalingPolicy.Builder getManagedScalingPolicy() {
            return this.managedScalingPolicy != null ? this.managedScalingPolicy.toBuilder() : null;
        }

        @Override
        public final Builder managedScalingPolicy(ManagedScalingPolicy managedScalingPolicy) {
            this.managedScalingPolicy = managedScalingPolicy;
            return this;
        }

        public final void setManagedScalingPolicy(ManagedScalingPolicy.BuilderImpl managedScalingPolicy) {
            this.managedScalingPolicy = managedScalingPolicy != null ? managedScalingPolicy.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutManagedScalingPolicyRequest build() {
            return new PutManagedScalingPolicyRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EmrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutManagedScalingPolicyRequest> {
        public Builder clusterId(String var1);

        public Builder managedScalingPolicy(ManagedScalingPolicy var1);

        default public Builder managedScalingPolicy(Consumer<ManagedScalingPolicy.Builder> managedScalingPolicy) {
            return this.managedScalingPolicy((ManagedScalingPolicy)((ManagedScalingPolicy.Builder)ManagedScalingPolicy.builder().applyMutation(managedScalingPolicy)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

