/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VolumeSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VolumeSpecification> {
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeType").getter(VolumeSpecification.getter(VolumeSpecification::volumeType)).setter(VolumeSpecification.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeType").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(VolumeSpecification.getter(VolumeSpecification::iops)).setter(VolumeSpecification.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<Integer> SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SizeInGB").getter(VolumeSpecification.getter(VolumeSpecification::sizeInGB)).setter(VolumeSpecification.setter(Builder::sizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SizeInGB").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_TYPE_FIELD, IOPS_FIELD, SIZE_IN_GB_FIELD));
    private static final long serialVersionUID = 1L;
    private final String volumeType;
    private final Integer iops;
    private final Integer sizeInGB;

    private VolumeSpecification(BuilderImpl builder) {
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
        this.sizeInGB = builder.sizeInGB;
    }

    public final String volumeType() {
        return this.volumeType;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final Integer sizeInGB() {
        return this.sizeInGB;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.sizeInGB());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeSpecification)) {
            return false;
        }
        VolumeSpecification other = (VolumeSpecification)obj;
        return Objects.equals(this.volumeType(), other.volumeType()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.sizeInGB(), other.sizeInGB());
    }

    public final String toString() {
        return ToString.builder((String)"VolumeSpecification").add("VolumeType", (Object)this.volumeType()).add("Iops", (Object)this.iops()).add("SizeInGB", (Object)this.sizeInGB()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeType()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "SizeInGB": {
                return Optional.ofNullable(clazz.cast(this.sizeInGB()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VolumeSpecification, T> g) {
        return obj -> g.apply((VolumeSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeType;
        private Integer iops;
        private Integer sizeInGB;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeSpecification model) {
            this.volumeType(model.volumeType);
            this.iops(model.iops);
            this.sizeInGB(model.sizeInGB);
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        @Transient
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        @Transient
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final Integer getSizeInGB() {
            return this.sizeInGB;
        }

        public final void setSizeInGB(Integer sizeInGB) {
            this.sizeInGB = sizeInGB;
        }

        @Override
        @Transient
        public final Builder sizeInGB(Integer sizeInGB) {
            this.sizeInGB = sizeInGB;
            return this;
        }

        public VolumeSpecification build() {
            return new VolumeSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VolumeSpecification> {
        public Builder volumeType(String var1);

        public Builder iops(Integer var1);

        public Builder sizeInGB(Integer var1);
    }
}

