/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.services.emr.model.ConfigurationListCopier;
import software.amazon.awssdk.services.emr.model.EbsBlockDevice;
import software.amazon.awssdk.services.emr.model.EbsBlockDeviceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceTypeSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceTypeSpecification> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(InstanceTypeSpecification.getter(InstanceTypeSpecification::instanceType)).setter(InstanceTypeSpecification.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<Integer> WEIGHTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("WeightedCapacity").getter(InstanceTypeSpecification.getter(InstanceTypeSpecification::weightedCapacity)).setter(InstanceTypeSpecification.setter(Builder::weightedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").build()}).build();
    private static final SdkField<String> BID_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BidPrice").getter(InstanceTypeSpecification.getter(InstanceTypeSpecification::bidPrice)).setter(InstanceTypeSpecification.setter(Builder::bidPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BidPrice").build()}).build();
    private static final SdkField<Double> BID_PRICE_AS_PERCENTAGE_OF_ON_DEMAND_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BidPriceAsPercentageOfOnDemandPrice").getter(InstanceTypeSpecification.getter(InstanceTypeSpecification::bidPriceAsPercentageOfOnDemandPrice)).setter(InstanceTypeSpecification.setter(Builder::bidPriceAsPercentageOfOnDemandPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BidPriceAsPercentageOfOnDemandPrice").build()}).build();
    private static final SdkField<List<Configuration>> CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Configurations").getter(InstanceTypeSpecification.getter(InstanceTypeSpecification::configurations)).setter(InstanceTypeSpecification.setter(Builder::configurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Configuration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EbsBlockDevice>> EBS_BLOCK_DEVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EbsBlockDevices").getter(InstanceTypeSpecification.getter(InstanceTypeSpecification::ebsBlockDevices)).setter(InstanceTypeSpecification.setter(Builder::ebsBlockDevices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsBlockDevices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EbsBlockDevice::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EbsOptimized").getter(InstanceTypeSpecification.getter(InstanceTypeSpecification::ebsOptimized)).setter(InstanceTypeSpecification.setter(Builder::ebsOptimized)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, WEIGHTED_CAPACITY_FIELD, BID_PRICE_FIELD, BID_PRICE_AS_PERCENTAGE_OF_ON_DEMAND_PRICE_FIELD, CONFIGURATIONS_FIELD, EBS_BLOCK_DEVICES_FIELD, EBS_OPTIMIZED_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final Integer weightedCapacity;
    private final String bidPrice;
    private final Double bidPriceAsPercentageOfOnDemandPrice;
    private final List<Configuration> configurations;
    private final List<EbsBlockDevice> ebsBlockDevices;
    private final Boolean ebsOptimized;

    private InstanceTypeSpecification(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.weightedCapacity = builder.weightedCapacity;
        this.bidPrice = builder.bidPrice;
        this.bidPriceAsPercentageOfOnDemandPrice = builder.bidPriceAsPercentageOfOnDemandPrice;
        this.configurations = builder.configurations;
        this.ebsBlockDevices = builder.ebsBlockDevices;
        this.ebsOptimized = builder.ebsOptimized;
    }

    public final String instanceType() {
        return this.instanceType;
    }

    public final Integer weightedCapacity() {
        return this.weightedCapacity;
    }

    public final String bidPrice() {
        return this.bidPrice;
    }

    public final Double bidPriceAsPercentageOfOnDemandPrice() {
        return this.bidPriceAsPercentageOfOnDemandPrice;
    }

    public final boolean hasConfigurations() {
        return this.configurations != null && !(this.configurations instanceof SdkAutoConstructList);
    }

    public final List<Configuration> configurations() {
        return this.configurations;
    }

    public final boolean hasEbsBlockDevices() {
        return this.ebsBlockDevices != null && !(this.ebsBlockDevices instanceof SdkAutoConstructList);
    }

    public final List<EbsBlockDevice> ebsBlockDevices() {
        return this.ebsBlockDevices;
    }

    public final Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPriceAsPercentageOfOnDemandPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConfigurations() ? this.configurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEbsBlockDevices() ? this.ebsBlockDevices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ebsOptimized());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceTypeSpecification)) {
            return false;
        }
        InstanceTypeSpecification other = (InstanceTypeSpecification)obj;
        return Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && Objects.equals(this.bidPrice(), other.bidPrice()) && Objects.equals(this.bidPriceAsPercentageOfOnDemandPrice(), other.bidPriceAsPercentageOfOnDemandPrice()) && this.hasConfigurations() == other.hasConfigurations() && Objects.equals(this.configurations(), other.configurations()) && this.hasEbsBlockDevices() == other.hasEbsBlockDevices() && Objects.equals(this.ebsBlockDevices(), other.ebsBlockDevices()) && Objects.equals(this.ebsOptimized(), other.ebsOptimized());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceTypeSpecification").add("InstanceType", (Object)this.instanceType()).add("WeightedCapacity", (Object)this.weightedCapacity()).add("BidPrice", (Object)this.bidPrice()).add("BidPriceAsPercentageOfOnDemandPrice", (Object)this.bidPriceAsPercentageOfOnDemandPrice()).add("Configurations", this.hasConfigurations() ? this.configurations() : null).add("EbsBlockDevices", this.hasEbsBlockDevices() ? this.ebsBlockDevices() : null).add("EbsOptimized", (Object)this.ebsOptimized()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "WeightedCapacity": {
                return Optional.ofNullable(clazz.cast(this.weightedCapacity()));
            }
            case "BidPrice": {
                return Optional.ofNullable(clazz.cast(this.bidPrice()));
            }
            case "BidPriceAsPercentageOfOnDemandPrice": {
                return Optional.ofNullable(clazz.cast(this.bidPriceAsPercentageOfOnDemandPrice()));
            }
            case "Configurations": {
                return Optional.ofNullable(clazz.cast(this.configurations()));
            }
            case "EbsBlockDevices": {
                return Optional.ofNullable(clazz.cast(this.ebsBlockDevices()));
            }
            case "EbsOptimized": {
                return Optional.ofNullable(clazz.cast(this.ebsOptimized()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceTypeSpecification, T> g) {
        return obj -> g.apply((InstanceTypeSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private Integer weightedCapacity;
        private String bidPrice;
        private Double bidPriceAsPercentageOfOnDemandPrice;
        private List<Configuration> configurations = DefaultSdkAutoConstructList.getInstance();
        private List<EbsBlockDevice> ebsBlockDevices = DefaultSdkAutoConstructList.getInstance();
        private Boolean ebsOptimized;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceTypeSpecification model) {
            this.instanceType(model.instanceType);
            this.weightedCapacity(model.weightedCapacity);
            this.bidPrice(model.bidPrice);
            this.bidPriceAsPercentageOfOnDemandPrice(model.bidPriceAsPercentageOfOnDemandPrice);
            this.configurations(model.configurations);
            this.ebsBlockDevices(model.ebsBlockDevices);
            this.ebsOptimized(model.ebsOptimized);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final Integer getWeightedCapacity() {
            return this.weightedCapacity;
        }

        public final void setWeightedCapacity(Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        @Override
        @Transient
        public final Builder weightedCapacity(Integer weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        @Override
        @Transient
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final Double getBidPriceAsPercentageOfOnDemandPrice() {
            return this.bidPriceAsPercentageOfOnDemandPrice;
        }

        public final void setBidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
        }

        @Override
        @Transient
        public final Builder bidPriceAsPercentageOfOnDemandPrice(Double bidPriceAsPercentageOfOnDemandPrice) {
            this.bidPriceAsPercentageOfOnDemandPrice = bidPriceAsPercentageOfOnDemandPrice;
            return this;
        }

        public final List<Configuration.Builder> getConfigurations() {
            List<Configuration.Builder> result = ConfigurationListCopier.copyToBuilder(this.configurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConfigurations(Collection<Configuration.BuilderImpl> configurations) {
            this.configurations = ConfigurationListCopier.copyFromBuilder(configurations);
        }

        @Override
        @Transient
        public final Builder configurations(Collection<Configuration> configurations) {
            this.configurations = ConfigurationListCopier.copy(configurations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder configurations(Configuration ... configurations) {
            this.configurations(Arrays.asList(configurations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder configurations(Consumer<Configuration.Builder> ... configurations) {
            this.configurations(Stream.of(configurations).map(c -> (Configuration)((Configuration.Builder)Configuration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EbsBlockDevice.Builder> getEbsBlockDevices() {
            List<EbsBlockDevice.Builder> result = EbsBlockDeviceListCopier.copyToBuilder(this.ebsBlockDevices);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEbsBlockDevices(Collection<EbsBlockDevice.BuilderImpl> ebsBlockDevices) {
            this.ebsBlockDevices = EbsBlockDeviceListCopier.copyFromBuilder(ebsBlockDevices);
        }

        @Override
        @Transient
        public final Builder ebsBlockDevices(Collection<EbsBlockDevice> ebsBlockDevices) {
            this.ebsBlockDevices = EbsBlockDeviceListCopier.copy(ebsBlockDevices);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ebsBlockDevices(EbsBlockDevice ... ebsBlockDevices) {
            this.ebsBlockDevices(Arrays.asList(ebsBlockDevices));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder ebsBlockDevices(Consumer<EbsBlockDevice.Builder> ... ebsBlockDevices) {
            this.ebsBlockDevices(Stream.of(ebsBlockDevices).map(c -> (EbsBlockDevice)((EbsBlockDevice.Builder)EbsBlockDevice.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        @Transient
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public InstanceTypeSpecification build() {
            return new InstanceTypeSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceTypeSpecification> {
        public Builder instanceType(String var1);

        public Builder weightedCapacity(Integer var1);

        public Builder bidPrice(String var1);

        public Builder bidPriceAsPercentageOfOnDemandPrice(Double var1);

        public Builder configurations(Collection<Configuration> var1);

        public Builder configurations(Configuration ... var1);

        public Builder configurations(Consumer<Configuration.Builder> ... var1);

        public Builder ebsBlockDevices(Collection<EbsBlockDevice> var1);

        public Builder ebsBlockDevices(EbsBlockDevice ... var1);

        public Builder ebsBlockDevices(Consumer<EbsBlockDevice.Builder> ... var1);

        public Builder ebsOptimized(Boolean var1);
    }
}

