/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details for an Amazon EMR Studio including ID, creation time, name, and so on.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Studio implements SdkPojo, Serializable, ToCopyableBuilder<Studio.Builder, Studio> {
    private static final SdkField<String> STUDIO_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioId").getter(getter(Studio::studioId)).setter(setter(Builder::studioId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioId").build()).build();

    private static final SdkField<String> STUDIO_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StudioArn").getter(getter(Studio::studioArn)).setter(setter(Builder::studioArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StudioArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Studio::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Studio::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> AUTH_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthMode").getter(getter(Studio::authModeAsString)).setter(setter(Builder::authMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthMode").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("VpcId")
            .getter(getter(Studio::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SubnetIds")
            .getter(getter(Studio::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SERVICE_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRole").getter(getter(Studio::serviceRole)).setter(setter(Builder::serviceRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRole").build()).build();

    private static final SdkField<String> USER_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserRole").getter(getter(Studio::userRole)).setter(setter(Builder::userRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserRole").build()).build();

    private static final SdkField<String> WORKSPACE_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WorkspaceSecurityGroupId").getter(getter(Studio::workspaceSecurityGroupId))
            .setter(setter(Builder::workspaceSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WorkspaceSecurityGroupId").build())
            .build();

    private static final SdkField<String> ENGINE_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineSecurityGroupId").getter(getter(Studio::engineSecurityGroupId))
            .setter(setter(Builder::engineSecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineSecurityGroupId").build())
            .build();

    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Url")
            .getter(getter(Studio::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(Studio::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> DEFAULT_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultS3Location").getter(getter(Studio::defaultS3Location)).setter(setter(Builder::defaultS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultS3Location").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Studio::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STUDIO_ID_FIELD,
            STUDIO_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, AUTH_MODE_FIELD, VPC_ID_FIELD, SUBNET_IDS_FIELD, SERVICE_ROLE_FIELD,
            USER_ROLE_FIELD, WORKSPACE_SECURITY_GROUP_ID_FIELD, ENGINE_SECURITY_GROUP_ID_FIELD, URL_FIELD, CREATION_TIME_FIELD,
            DEFAULT_S3_LOCATION_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String studioId;

    private final String studioArn;

    private final String name;

    private final String description;

    private final String authMode;

    private final String vpcId;

    private final List<String> subnetIds;

    private final String serviceRole;

    private final String userRole;

    private final String workspaceSecurityGroupId;

    private final String engineSecurityGroupId;

    private final String url;

    private final Instant creationTime;

    private final String defaultS3Location;

    private final List<Tag> tags;

    private Studio(BuilderImpl builder) {
        this.studioId = builder.studioId;
        this.studioArn = builder.studioArn;
        this.name = builder.name;
        this.description = builder.description;
        this.authMode = builder.authMode;
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.serviceRole = builder.serviceRole;
        this.userRole = builder.userRole;
        this.workspaceSecurityGroupId = builder.workspaceSecurityGroupId;
        this.engineSecurityGroupId = builder.engineSecurityGroupId;
        this.url = builder.url;
        this.creationTime = builder.creationTime;
        this.defaultS3Location = builder.defaultS3Location;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID of the EMR Studio.
     * </p>
     * 
     * @return The ID of the EMR Studio.
     */
    public final String studioId() {
        return studioId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the EMR Studio.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the EMR Studio.
     */
    public final String studioArn() {
        return studioArn;
    }

    /**
     * <p>
     * The name of the EMR Studio.
     * </p>
     * 
     * @return The name of the EMR Studio.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The detailed description of the EMR Studio.
     * </p>
     * 
     * @return The detailed description of the EMR Studio.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether the Studio authenticates users using single sign-on (SSO) or IAM.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return Specifies whether the Studio authenticates users using single sign-on (SSO) or IAM.
     * @see AuthMode
     */
    public final AuthMode authMode() {
        return AuthMode.fromValue(authMode);
    }

    /**
     * <p>
     * Specifies whether the Studio authenticates users using single sign-on (SSO) or IAM.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authMode} will
     * return {@link AuthMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #authModeAsString}.
     * </p>
     * 
     * @return Specifies whether the Studio authenticates users using single sign-on (SSO) or IAM.
     * @see AuthMode
     */
    public final String authModeAsString() {
        return authMode;
    }

    /**
     * <p>
     * The ID of the VPC associated with the EMR Studio.
     * </p>
     * 
     * @return The ID of the VPC associated with the EMR Studio.
     */
    public final String vpcId() {
        return vpcId;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of IDs of the subnets associated with the Amazon EMR Studio.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of IDs of the subnets associated with the Amazon EMR Studio.
     */
    public final List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * The name of the IAM role assumed by the Amazon EMR Studio.
     * </p>
     * 
     * @return The name of the IAM role assumed by the Amazon EMR Studio.
     */
    public final String serviceRole() {
        return serviceRole;
    }

    /**
     * <p>
     * The name of the IAM role assumed by users logged in to the Amazon EMR Studio.
     * </p>
     * 
     * @return The name of the IAM role assumed by users logged in to the Amazon EMR Studio.
     */
    public final String userRole() {
        return userRole;
    }

    /**
     * <p>
     * The ID of the Workspace security group associated with the Amazon EMR Studio. The Workspace security group allows
     * outbound network traffic to resources in the Engine security group and to the internet.
     * </p>
     * 
     * @return The ID of the Workspace security group associated with the Amazon EMR Studio. The Workspace security
     *         group allows outbound network traffic to resources in the Engine security group and to the internet.
     */
    public final String workspaceSecurityGroupId() {
        return workspaceSecurityGroupId;
    }

    /**
     * <p>
     * The ID of the Engine security group associated with the Amazon EMR Studio. The Engine security group allows
     * inbound network traffic from resources in the Workspace security group.
     * </p>
     * 
     * @return The ID of the Engine security group associated with the Amazon EMR Studio. The Engine security group
     *         allows inbound network traffic from resources in the Workspace security group.
     */
    public final String engineSecurityGroupId() {
        return engineSecurityGroupId;
    }

    /**
     * <p>
     * The unique access URL of the Amazon EMR Studio.
     * </p>
     * 
     * @return The unique access URL of the Amazon EMR Studio.
     */
    public final String url() {
        return url;
    }

    /**
     * <p>
     * The time the Amazon EMR Studio was created.
     * </p>
     * 
     * @return The time the Amazon EMR Studio was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The default Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     * </p>
     * 
     * @return The default Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
     */
    public final String defaultS3Location() {
        return defaultS3Location;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags associated with the Amazon EMR Studio.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags associated with the Amazon EMR Studio.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(studioId());
        hashCode = 31 * hashCode + Objects.hashCode(studioArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(authModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(hasSubnetIds() ? subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceRole());
        hashCode = 31 * hashCode + Objects.hashCode(userRole());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(engineSecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(defaultS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Studio)) {
            return false;
        }
        Studio other = (Studio) obj;
        return Objects.equals(studioId(), other.studioId()) && Objects.equals(studioArn(), other.studioArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(authModeAsString(), other.authModeAsString()) && Objects.equals(vpcId(), other.vpcId())
                && hasSubnetIds() == other.hasSubnetIds() && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(serviceRole(), other.serviceRole()) && Objects.equals(userRole(), other.userRole())
                && Objects.equals(workspaceSecurityGroupId(), other.workspaceSecurityGroupId())
                && Objects.equals(engineSecurityGroupId(), other.engineSecurityGroupId()) && Objects.equals(url(), other.url())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(defaultS3Location(), other.defaultS3Location()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Studio").add("StudioId", studioId()).add("StudioArn", studioArn()).add("Name", name())
                .add("Description", description()).add("AuthMode", authModeAsString()).add("VpcId", vpcId())
                .add("SubnetIds", hasSubnetIds() ? subnetIds() : null).add("ServiceRole", serviceRole())
                .add("UserRole", userRole()).add("WorkspaceSecurityGroupId", workspaceSecurityGroupId())
                .add("EngineSecurityGroupId", engineSecurityGroupId()).add("Url", url()).add("CreationTime", creationTime())
                .add("DefaultS3Location", defaultS3Location()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StudioId":
            return Optional.ofNullable(clazz.cast(studioId()));
        case "StudioArn":
            return Optional.ofNullable(clazz.cast(studioArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "AuthMode":
            return Optional.ofNullable(clazz.cast(authModeAsString()));
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "ServiceRole":
            return Optional.ofNullable(clazz.cast(serviceRole()));
        case "UserRole":
            return Optional.ofNullable(clazz.cast(userRole()));
        case "WorkspaceSecurityGroupId":
            return Optional.ofNullable(clazz.cast(workspaceSecurityGroupId()));
        case "EngineSecurityGroupId":
            return Optional.ofNullable(clazz.cast(engineSecurityGroupId()));
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "DefaultS3Location":
            return Optional.ofNullable(clazz.cast(defaultS3Location()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Studio, T> g) {
        return obj -> g.apply((Studio) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Studio> {
        /**
         * <p>
         * The ID of the EMR Studio.
         * </p>
         * 
         * @param studioId
         *        The ID of the EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioId(String studioId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the EMR Studio.
         * </p>
         * 
         * @param studioArn
         *        The Amazon Resource Name (ARN) of the EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder studioArn(String studioArn);

        /**
         * <p>
         * The name of the EMR Studio.
         * </p>
         * 
         * @param name
         *        The name of the EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The detailed description of the EMR Studio.
         * </p>
         * 
         * @param description
         *        The detailed description of the EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether the Studio authenticates users using single sign-on (SSO) or IAM.
         * </p>
         * 
         * @param authMode
         *        Specifies whether the Studio authenticates users using single sign-on (SSO) or IAM.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(String authMode);

        /**
         * <p>
         * Specifies whether the Studio authenticates users using single sign-on (SSO) or IAM.
         * </p>
         * 
         * @param authMode
         *        Specifies whether the Studio authenticates users using single sign-on (SSO) or IAM.
         * @see AuthMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthMode
         */
        Builder authMode(AuthMode authMode);

        /**
         * <p>
         * The ID of the VPC associated with the EMR Studio.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC associated with the EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * The list of IDs of the subnets associated with the Amazon EMR Studio.
         * </p>
         * 
         * @param subnetIds
         *        The list of IDs of the subnets associated with the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * The list of IDs of the subnets associated with the Amazon EMR Studio.
         * </p>
         * 
         * @param subnetIds
         *        The list of IDs of the subnets associated with the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * The name of the IAM role assumed by the Amazon EMR Studio.
         * </p>
         * 
         * @param serviceRole
         *        The name of the IAM role assumed by the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRole(String serviceRole);

        /**
         * <p>
         * The name of the IAM role assumed by users logged in to the Amazon EMR Studio.
         * </p>
         * 
         * @param userRole
         *        The name of the IAM role assumed by users logged in to the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userRole(String userRole);

        /**
         * <p>
         * The ID of the Workspace security group associated with the Amazon EMR Studio. The Workspace security group
         * allows outbound network traffic to resources in the Engine security group and to the internet.
         * </p>
         * 
         * @param workspaceSecurityGroupId
         *        The ID of the Workspace security group associated with the Amazon EMR Studio. The Workspace security
         *        group allows outbound network traffic to resources in the Engine security group and to the internet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceSecurityGroupId(String workspaceSecurityGroupId);

        /**
         * <p>
         * The ID of the Engine security group associated with the Amazon EMR Studio. The Engine security group allows
         * inbound network traffic from resources in the Workspace security group.
         * </p>
         * 
         * @param engineSecurityGroupId
         *        The ID of the Engine security group associated with the Amazon EMR Studio. The Engine security group
         *        allows inbound network traffic from resources in the Workspace security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineSecurityGroupId(String engineSecurityGroupId);

        /**
         * <p>
         * The unique access URL of the Amazon EMR Studio.
         * </p>
         * 
         * @param url
         *        The unique access URL of the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * The time the Amazon EMR Studio was created.
         * </p>
         * 
         * @param creationTime
         *        The time the Amazon EMR Studio was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The default Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
         * </p>
         * 
         * @param defaultS3Location
         *        The default Amazon S3 location to back up Amazon EMR Studio Workspaces and notebook files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultS3Location(String defaultS3Location);

        /**
         * <p>
         * A list of tags associated with the Amazon EMR Studio.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags associated with the Amazon EMR Studio.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the Amazon EMR Studio.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags associated with the Amazon EMR Studio.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String studioId;

        private String studioArn;

        private String name;

        private String description;

        private String authMode;

        private String vpcId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private String serviceRole;

        private String userRole;

        private String workspaceSecurityGroupId;

        private String engineSecurityGroupId;

        private String url;

        private Instant creationTime;

        private String defaultS3Location;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Studio model) {
            studioId(model.studioId);
            studioArn(model.studioArn);
            name(model.name);
            description(model.description);
            authMode(model.authMode);
            vpcId(model.vpcId);
            subnetIds(model.subnetIds);
            serviceRole(model.serviceRole);
            userRole(model.userRole);
            workspaceSecurityGroupId(model.workspaceSecurityGroupId);
            engineSecurityGroupId(model.engineSecurityGroupId);
            url(model.url);
            creationTime(model.creationTime);
            defaultS3Location(model.defaultS3Location);
            tags(model.tags);
        }

        public final String getStudioId() {
            return studioId;
        }

        @Override
        public final Builder studioId(String studioId) {
            this.studioId = studioId;
            return this;
        }

        public final void setStudioId(String studioId) {
            this.studioId = studioId;
        }

        public final String getStudioArn() {
            return studioArn;
        }

        @Override
        public final Builder studioArn(String studioArn) {
            this.studioArn = studioArn;
            return this;
        }

        public final void setStudioArn(String studioArn) {
            this.studioArn = studioArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getAuthMode() {
            return authMode;
        }

        @Override
        public final Builder authMode(String authMode) {
            this.authMode = authMode;
            return this;
        }

        @Override
        public final Builder authMode(AuthMode authMode) {
            this.authMode(authMode == null ? null : authMode.toString());
            return this;
        }

        public final void setAuthMode(String authMode) {
            this.authMode = authMode;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<String> getSubnetIds() {
            if (subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdListCopier.copy(subnetIds);
        }

        public final String getServiceRole() {
            return serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        public final String getUserRole() {
            return userRole;
        }

        @Override
        public final Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        public final void setUserRole(String userRole) {
            this.userRole = userRole;
        }

        public final String getWorkspaceSecurityGroupId() {
            return workspaceSecurityGroupId;
        }

        @Override
        public final Builder workspaceSecurityGroupId(String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
            return this;
        }

        public final void setWorkspaceSecurityGroupId(String workspaceSecurityGroupId) {
            this.workspaceSecurityGroupId = workspaceSecurityGroupId;
        }

        public final String getEngineSecurityGroupId() {
            return engineSecurityGroupId;
        }

        @Override
        public final Builder engineSecurityGroupId(String engineSecurityGroupId) {
            this.engineSecurityGroupId = engineSecurityGroupId;
            return this;
        }

        public final void setEngineSecurityGroupId(String engineSecurityGroupId) {
            this.engineSecurityGroupId = engineSecurityGroupId;
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getDefaultS3Location() {
            return defaultS3Location;
        }

        @Override
        public final Builder defaultS3Location(String defaultS3Location) {
            this.defaultS3Location = defaultS3Location;
            return this;
        }

        public final void setDefaultS3Location(String defaultS3Location) {
            this.defaultS3Location = defaultS3Location;
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Studio build() {
            return new Studio(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
