/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstanceFleetsResponse extends EmrResponse implements
        ToCopyableBuilder<ListInstanceFleetsResponse.Builder, ListInstanceFleetsResponse> {
    private static final SdkField<List<InstanceFleet>> INSTANCE_FLEETS_FIELD = SdkField
            .<List<InstanceFleet>> builder(MarshallingType.LIST)
            .memberName("InstanceFleets")
            .getter(getter(ListInstanceFleetsResponse::instanceFleets))
            .setter(setter(Builder::instanceFleets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceFleet> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceFleet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(ListInstanceFleetsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FLEETS_FIELD,
            MARKER_FIELD));

    private final List<InstanceFleet> instanceFleets;

    private final String marker;

    private ListInstanceFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceFleets = builder.instanceFleets;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the InstanceFleets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasInstanceFleets() {
        return instanceFleets != null && !(instanceFleets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of instance fleets for the cluster and given filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceFleets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of instance fleets for the cluster and given filters.
     */
    public final List<InstanceFleet> instanceFleets() {
        return instanceFleets;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceFleets() ? instanceFleets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceFleetsResponse)) {
            return false;
        }
        ListInstanceFleetsResponse other = (ListInstanceFleetsResponse) obj;
        return hasInstanceFleets() == other.hasInstanceFleets() && Objects.equals(instanceFleets(), other.instanceFleets())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstanceFleetsResponse")
                .add("InstanceFleets", hasInstanceFleets() ? instanceFleets() : null).add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceFleets":
            return Optional.ofNullable(clazz.cast(instanceFleets()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceFleetsResponse, T> g) {
        return obj -> g.apply((ListInstanceFleetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInstanceFleetsResponse> {
        /**
         * <p>
         * The list of instance fleets for the cluster and given filters.
         * </p>
         * 
         * @param instanceFleets
         *        The list of instance fleets for the cluster and given filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFleets(Collection<InstanceFleet> instanceFleets);

        /**
         * <p>
         * The list of instance fleets for the cluster and given filters.
         * </p>
         * 
         * @param instanceFleets
         *        The list of instance fleets for the cluster and given filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFleets(InstanceFleet... instanceFleets);

        /**
         * <p>
         * The list of instance fleets for the cluster and given filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceFleet>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceFleet>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceFleet>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceFleets(List<InstanceFleet>)}.
         * 
         * @param instanceFleets
         *        a consumer that will call methods on {@link List<InstanceFleet>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceFleets(List<InstanceFleet>)
         */
        Builder instanceFleets(Consumer<InstanceFleet.Builder>... instanceFleets);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private List<InstanceFleet> instanceFleets = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceFleetsResponse model) {
            super(model);
            instanceFleets(model.instanceFleets);
            marker(model.marker);
        }

        public final Collection<InstanceFleet.Builder> getInstanceFleets() {
            if (instanceFleets instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceFleets != null ? instanceFleets.stream().map(InstanceFleet::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder instanceFleets(Collection<InstanceFleet> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copy(instanceFleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFleets(InstanceFleet... instanceFleets) {
            instanceFleets(Arrays.asList(instanceFleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceFleets(Consumer<InstanceFleet.Builder>... instanceFleets) {
            instanceFleets(Stream.of(instanceFleets).map(c -> InstanceFleet.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceFleets(Collection<InstanceFleet.BuilderImpl> instanceFleets) {
            this.instanceFleets = InstanceFleetListCopier.copyFromBuilder(instanceFleets);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListInstanceFleetsResponse build() {
            return new ListInstanceFleetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
