/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties that describe the AWS principal that created the <code>BlockPublicAccessConfiguration</code> using the
 * <code>PutBlockPublicAccessConfiguration</code> action as well as the date and time that the configuration was
 * created. Each time a configuration for block public access is updated, Amazon EMR updates this metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockPublicAccessConfigurationMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockPublicAccessConfigurationMetadata.Builder, BlockPublicAccessConfigurationMetadata> {
    private static final SdkField<Instant> CREATION_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDateTime").getter(getter(BlockPublicAccessConfigurationMetadata::creationDateTime))
            .setter(setter(Builder::creationDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDateTime").build()).build();

    private static final SdkField<String> CREATED_BY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedByArn").getter(getter(BlockPublicAccessConfigurationMetadata::createdByArn))
            .setter(setter(Builder::createdByArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedByArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_DATE_TIME_FIELD,
            CREATED_BY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant creationDateTime;

    private final String createdByArn;

    private BlockPublicAccessConfigurationMetadata(BuilderImpl builder) {
        this.creationDateTime = builder.creationDateTime;
        this.createdByArn = builder.createdByArn;
    }

    /**
     * <p>
     * The date and time that the configuration was created.
     * </p>
     * 
     * @return The date and time that the configuration was created.
     */
    public final Instant creationDateTime() {
        return creationDateTime;
    }

    /**
     * <p>
     * The Amazon Resource Name that created or last modified the configuration.
     * </p>
     * 
     * @return The Amazon Resource Name that created or last modified the configuration.
     */
    public final String createdByArn() {
        return createdByArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdByArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockPublicAccessConfigurationMetadata)) {
            return false;
        }
        BlockPublicAccessConfigurationMetadata other = (BlockPublicAccessConfigurationMetadata) obj;
        return Objects.equals(creationDateTime(), other.creationDateTime())
                && Objects.equals(createdByArn(), other.createdByArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockPublicAccessConfigurationMetadata").add("CreationDateTime", creationDateTime())
                .add("CreatedByArn", createdByArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationDateTime":
            return Optional.ofNullable(clazz.cast(creationDateTime()));
        case "CreatedByArn":
            return Optional.ofNullable(clazz.cast(createdByArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlockPublicAccessConfigurationMetadata, T> g) {
        return obj -> g.apply((BlockPublicAccessConfigurationMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockPublicAccessConfigurationMetadata> {
        /**
         * <p>
         * The date and time that the configuration was created.
         * </p>
         * 
         * @param creationDateTime
         *        The date and time that the configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDateTime(Instant creationDateTime);

        /**
         * <p>
         * The Amazon Resource Name that created or last modified the configuration.
         * </p>
         * 
         * @param createdByArn
         *        The Amazon Resource Name that created or last modified the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdByArn(String createdByArn);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationDateTime;

        private String createdByArn;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockPublicAccessConfigurationMetadata model) {
            creationDateTime(model.creationDateTime);
            createdByArn(model.createdByArn);
        }

        public final Instant getCreationDateTime() {
            return creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final String getCreatedByArn() {
            return createdByArn;
        }

        @Override
        public final Builder createdByArn(String createdByArn) {
            this.createdByArn = createdByArn;
            return this;
        }

        public final void setCreatedByArn(String createdByArn) {
            this.createdByArn = createdByArn;
        }

        @Override
        public BlockPublicAccessConfigurationMetadata build() {
            return new BlockPublicAccessConfigurationMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
