/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Output from an AddInstanceGroups call.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddInstanceGroupsResponse extends EmrResponse implements
        ToCopyableBuilder<AddInstanceGroupsResponse.Builder, AddInstanceGroupsResponse> {
    private static final SdkField<String> JOB_FLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("JobFlowId").getter(getter(AddInstanceGroupsResponse::jobFlowId)).setter(setter(Builder::jobFlowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobFlowId").build()).build();

    private static final SdkField<List<String>> INSTANCE_GROUP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("InstanceGroupIds")
            .getter(getter(AddInstanceGroupsResponse::instanceGroupIds))
            .setter(setter(Builder::instanceGroupIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterArn").getter(getter(AddInstanceGroupsResponse::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_FLOW_ID_FIELD,
            INSTANCE_GROUP_IDS_FIELD, CLUSTER_ARN_FIELD));

    private final String jobFlowId;

    private final List<String> instanceGroupIds;

    private final String clusterArn;

    private AddInstanceGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.jobFlowId = builder.jobFlowId;
        this.instanceGroupIds = builder.instanceGroupIds;
        this.clusterArn = builder.clusterArn;
    }

    /**
     * <p>
     * The job flow ID in which the instance groups are added.
     * </p>
     * 
     * @return The job flow ID in which the instance groups are added.
     */
    public final String jobFlowId() {
        return jobFlowId;
    }

    /**
     * Returns true if the InstanceGroupIds property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasInstanceGroupIds() {
        return instanceGroupIds != null && !(instanceGroupIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Instance group IDs of the newly created instance groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceGroupIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Instance group IDs of the newly created instance groups.
     */
    public final List<String> instanceGroupIds() {
        return instanceGroupIds;
    }

    /**
     * <p>
     * The Amazon Resource Name of the cluster.
     * </p>
     * 
     * @return The Amazon Resource Name of the cluster.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(jobFlowId());
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceGroupIds() ? instanceGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceGroupsResponse)) {
            return false;
        }
        AddInstanceGroupsResponse other = (AddInstanceGroupsResponse) obj;
        return Objects.equals(jobFlowId(), other.jobFlowId()) && hasInstanceGroupIds() == other.hasInstanceGroupIds()
                && Objects.equals(instanceGroupIds(), other.instanceGroupIds())
                && Objects.equals(clusterArn(), other.clusterArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddInstanceGroupsResponse").add("JobFlowId", jobFlowId())
                .add("InstanceGroupIds", hasInstanceGroupIds() ? instanceGroupIds() : null).add("ClusterArn", clusterArn())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobFlowId":
            return Optional.ofNullable(clazz.cast(jobFlowId()));
        case "InstanceGroupIds":
            return Optional.ofNullable(clazz.cast(instanceGroupIds()));
        case "ClusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AddInstanceGroupsResponse, T> g) {
        return obj -> g.apply((AddInstanceGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrResponse.Builder, SdkPojo, CopyableBuilder<Builder, AddInstanceGroupsResponse> {
        /**
         * <p>
         * The job flow ID in which the instance groups are added.
         * </p>
         * 
         * @param jobFlowId
         *        The job flow ID in which the instance groups are added.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobFlowId(String jobFlowId);

        /**
         * <p>
         * Instance group IDs of the newly created instance groups.
         * </p>
         * 
         * @param instanceGroupIds
         *        Instance group IDs of the newly created instance groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupIds(Collection<String> instanceGroupIds);

        /**
         * <p>
         * Instance group IDs of the newly created instance groups.
         * </p>
         * 
         * @param instanceGroupIds
         *        Instance group IDs of the newly created instance groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceGroupIds(String... instanceGroupIds);

        /**
         * <p>
         * The Amazon Resource Name of the cluster.
         * </p>
         * 
         * @param clusterArn
         *        The Amazon Resource Name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);
    }

    static final class BuilderImpl extends EmrResponse.BuilderImpl implements Builder {
        private String jobFlowId;

        private List<String> instanceGroupIds = DefaultSdkAutoConstructList.getInstance();

        private String clusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceGroupsResponse model) {
            super(model);
            jobFlowId(model.jobFlowId);
            instanceGroupIds(model.instanceGroupIds);
            clusterArn(model.clusterArn);
        }

        public final String getJobFlowId() {
            return jobFlowId;
        }

        @Override
        public final Builder jobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
            return this;
        }

        public final void setJobFlowId(String jobFlowId) {
            this.jobFlowId = jobFlowId;
        }

        public final Collection<String> getInstanceGroupIds() {
            if (instanceGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return instanceGroupIds;
        }

        @Override
        public final Builder instanceGroupIds(Collection<String> instanceGroupIds) {
            this.instanceGroupIds = InstanceGroupIdsListCopier.copy(instanceGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceGroupIds(String... instanceGroupIds) {
            instanceGroupIds(Arrays.asList(instanceGroupIds));
            return this;
        }

        public final void setInstanceGroupIds(Collection<String> instanceGroupIds) {
            this.instanceGroupIds = InstanceGroupIdsListCopier.copy(instanceGroupIds);
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public AddInstanceGroupsResponse build() {
            return new AddInstanceGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
