/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.emr.model.InstanceRoleType;
import software.amazon.awssdk.services.emr.model.PlacementGroupStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PlacementGroupConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PlacementGroupConfig> {
    private static final SdkField<String> INSTANCE_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceRole").getter(PlacementGroupConfig.getter(PlacementGroupConfig::instanceRoleAsString)).setter(PlacementGroupConfig.setter(Builder::instanceRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRole").build()}).build();
    private static final SdkField<String> PLACEMENT_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PlacementStrategy").getter(PlacementGroupConfig.getter(PlacementGroupConfig::placementStrategyAsString)).setter(PlacementGroupConfig.setter(Builder::placementStrategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ROLE_FIELD, PLACEMENT_STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceRole;
    private final String placementStrategy;

    private PlacementGroupConfig(BuilderImpl builder) {
        this.instanceRole = builder.instanceRole;
        this.placementStrategy = builder.placementStrategy;
    }

    public InstanceRoleType instanceRole() {
        return InstanceRoleType.fromValue(this.instanceRole);
    }

    public String instanceRoleAsString() {
        return this.instanceRole;
    }

    public PlacementGroupStrategy placementStrategy() {
        return PlacementGroupStrategy.fromValue(this.placementStrategy);
    }

    public String placementStrategyAsString() {
        return this.placementStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRoleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.placementStrategyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlacementGroupConfig)) {
            return false;
        }
        PlacementGroupConfig other = (PlacementGroupConfig)obj;
        return Objects.equals(this.instanceRoleAsString(), other.instanceRoleAsString()) && Objects.equals(this.placementStrategyAsString(), other.placementStrategyAsString());
    }

    public String toString() {
        return ToString.builder((String)"PlacementGroupConfig").add("InstanceRole", (Object)this.instanceRoleAsString()).add("PlacementStrategy", (Object)this.placementStrategyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceRole": {
                return Optional.ofNullable(clazz.cast(this.instanceRoleAsString()));
            }
            case "PlacementStrategy": {
                return Optional.ofNullable(clazz.cast(this.placementStrategyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PlacementGroupConfig, T> g) {
        return obj -> g.apply((PlacementGroupConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceRole;
        private String placementStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(PlacementGroupConfig model) {
            this.instanceRole(model.instanceRole);
            this.placementStrategy(model.placementStrategy);
        }

        public final String getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        @Override
        public final Builder instanceRole(InstanceRoleType instanceRole) {
            this.instanceRole(instanceRole == null ? null : instanceRole.toString());
            return this;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        public final String getPlacementStrategy() {
            return this.placementStrategy;
        }

        @Override
        public final Builder placementStrategy(String placementStrategy) {
            this.placementStrategy = placementStrategy;
            return this;
        }

        @Override
        public final Builder placementStrategy(PlacementGroupStrategy placementStrategy) {
            this.placementStrategy(placementStrategy == null ? null : placementStrategy.toString());
            return this;
        }

        public final void setPlacementStrategy(String placementStrategy) {
            this.placementStrategy = placementStrategy;
        }

        public PlacementGroupConfig build() {
            return new PlacementGroupConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PlacementGroupConfig> {
        public Builder instanceRole(String var1);

        public Builder instanceRole(InstanceRoleType var1);

        public Builder placementStrategy(String var1);

        public Builder placementStrategy(PlacementGroupStrategy var1);
    }
}

