/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides status change reason details for the instance fleet.
 * </p>
 * <note>
 * <p>
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceFleetStateChangeReason implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceFleetStateChangeReason.Builder, InstanceFleetStateChangeReason> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceFleetStateChangeReason::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceFleetStateChangeReason::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String message;

    private InstanceFleetStateChangeReason(BuilderImpl builder) {
        this.code = builder.code;
        this.message = builder.message;
    }

    /**
     * <p>
     * A code corresponding to the reason the state change occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link InstanceFleetStateChangeReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codeAsString}.
     * </p>
     * 
     * @return A code corresponding to the reason the state change occurred.
     * @see InstanceFleetStateChangeReasonCode
     */
    public InstanceFleetStateChangeReasonCode code() {
        return InstanceFleetStateChangeReasonCode.fromValue(code);
    }

    /**
     * <p>
     * A code corresponding to the reason the state change occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link InstanceFleetStateChangeReasonCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #codeAsString}.
     * </p>
     * 
     * @return A code corresponding to the reason the state change occurred.
     * @see InstanceFleetStateChangeReasonCode
     */
    public String codeAsString() {
        return code;
    }

    /**
     * <p>
     * An explanatory message.
     * </p>
     * 
     * @return An explanatory message.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetStateChangeReason)) {
            return false;
        }
        InstanceFleetStateChangeReason other = (InstanceFleetStateChangeReason) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceFleetStateChangeReason").add("Code", codeAsString()).add("Message", message()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetStateChangeReason, T> g) {
        return obj -> g.apply((InstanceFleetStateChangeReason) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceFleetStateChangeReason> {
        /**
         * <p>
         * A code corresponding to the reason the state change occurred.
         * </p>
         * 
         * @param code
         *        A code corresponding to the reason the state change occurred.
         * @see InstanceFleetStateChangeReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceFleetStateChangeReasonCode
         */
        Builder code(String code);

        /**
         * <p>
         * A code corresponding to the reason the state change occurred.
         * </p>
         * 
         * @param code
         *        A code corresponding to the reason the state change occurred.
         * @see InstanceFleetStateChangeReasonCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceFleetStateChangeReasonCode
         */
        Builder code(InstanceFleetStateChangeReasonCode code);

        /**
         * <p>
         * An explanatory message.
         * </p>
         * 
         * @param message
         *        An explanatory message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetStateChangeReason model) {
            code(model.code);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(InstanceFleetStateChangeReasonCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public InstanceFleetStateChangeReason build() {
            return new InstanceFleetStateChangeReason(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
