/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input argument to the <a>CancelSteps</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CancelStepsRequest extends EmrRequest implements
        ToCopyableBuilder<CancelStepsRequest.Builder, CancelStepsRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CancelStepsRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<List<String>> STEP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CancelStepsRequest::stepIds))
            .setter(setter(Builder::stepIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STEP_CANCELLATION_OPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CancelStepsRequest::stepCancellationOptionAsString)).setter(setter(Builder::stepCancellationOption))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepCancellationOption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            STEP_IDS_FIELD, STEP_CANCELLATION_OPTION_FIELD));

    private final String clusterId;

    private final List<String> stepIds;

    private final String stepCancellationOption;

    private CancelStepsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.stepIds = builder.stepIds;
        this.stepCancellationOption = builder.stepCancellationOption;
    }

    /**
     * <p>
     * The <code>ClusterID</code> for which specified steps will be canceled. Use <a>RunJobFlow</a> and
     * <a>ListClusters</a> to get ClusterIDs.
     * </p>
     * 
     * @return The <code>ClusterID</code> for which specified steps will be canceled. Use <a>RunJobFlow</a> and
     *         <a>ListClusters</a> to get ClusterIDs.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * Returns true if the StepIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStepIds() {
        return stepIds != null && !(stepIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the specified
     * cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStepIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the
     *         specified cluster.
     */
    public List<String> stepIds() {
        return stepIds;
    }

    /**
     * <p>
     * The option to choose for cancelling <code>RUNNING</code> steps. By default, the value is
     * <code>SEND_INTERRUPT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #stepCancellationOption} will return {@link StepCancellationOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #stepCancellationOptionAsString}.
     * </p>
     * 
     * @return The option to choose for cancelling <code>RUNNING</code> steps. By default, the value is
     *         <code>SEND_INTERRUPT</code>.
     * @see StepCancellationOption
     */
    public StepCancellationOption stepCancellationOption() {
        return StepCancellationOption.fromValue(stepCancellationOption);
    }

    /**
     * <p>
     * The option to choose for cancelling <code>RUNNING</code> steps. By default, the value is
     * <code>SEND_INTERRUPT</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #stepCancellationOption} will return {@link StepCancellationOption#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #stepCancellationOptionAsString}.
     * </p>
     * 
     * @return The option to choose for cancelling <code>RUNNING</code> steps. By default, the value is
     *         <code>SEND_INTERRUPT</code>.
     * @see StepCancellationOption
     */
    public String stepCancellationOptionAsString() {
        return stepCancellationOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(stepIds());
        hashCode = 31 * hashCode + Objects.hashCode(stepCancellationOptionAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelStepsRequest)) {
            return false;
        }
        CancelStepsRequest other = (CancelStepsRequest) obj;
        return Objects.equals(clusterId(), other.clusterId()) && Objects.equals(stepIds(), other.stepIds())
                && Objects.equals(stepCancellationOptionAsString(), other.stepCancellationOptionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CancelStepsRequest").add("ClusterId", clusterId()).add("StepIds", stepIds())
                .add("StepCancellationOption", stepCancellationOptionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "StepIds":
            return Optional.ofNullable(clazz.cast(stepIds()));
        case "StepCancellationOption":
            return Optional.ofNullable(clazz.cast(stepCancellationOptionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CancelStepsRequest, T> g) {
        return obj -> g.apply((CancelStepsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CancelStepsRequest> {
        /**
         * <p>
         * The <code>ClusterID</code> for which specified steps will be canceled. Use <a>RunJobFlow</a> and
         * <a>ListClusters</a> to get ClusterIDs.
         * </p>
         * 
         * @param clusterId
         *        The <code>ClusterID</code> for which specified steps will be canceled. Use <a>RunJobFlow</a> and
         *        <a>ListClusters</a> to get ClusterIDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the
         * specified cluster.
         * </p>
         * 
         * @param stepIds
         *        The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the
         *        specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepIds(Collection<String> stepIds);

        /**
         * <p>
         * The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the
         * specified cluster.
         * </p>
         * 
         * @param stepIds
         *        The list of <code>StepIDs</code> to cancel. Use <a>ListSteps</a> to get steps and their states for the
         *        specified cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepIds(String... stepIds);

        /**
         * <p>
         * The option to choose for cancelling <code>RUNNING</code> steps. By default, the value is
         * <code>SEND_INTERRUPT</code>.
         * </p>
         * 
         * @param stepCancellationOption
         *        The option to choose for cancelling <code>RUNNING</code> steps. By default, the value is
         *        <code>SEND_INTERRUPT</code>.
         * @see StepCancellationOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepCancellationOption
         */
        Builder stepCancellationOption(String stepCancellationOption);

        /**
         * <p>
         * The option to choose for cancelling <code>RUNNING</code> steps. By default, the value is
         * <code>SEND_INTERRUPT</code>.
         * </p>
         * 
         * @param stepCancellationOption
         *        The option to choose for cancelling <code>RUNNING</code> steps. By default, the value is
         *        <code>SEND_INTERRUPT</code>.
         * @see StepCancellationOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepCancellationOption
         */
        Builder stepCancellationOption(StepCancellationOption stepCancellationOption);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String clusterId;

        private List<String> stepIds = DefaultSdkAutoConstructList.getInstance();

        private String stepCancellationOption;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelStepsRequest model) {
            super(model);
            clusterId(model.clusterId);
            stepIds(model.stepIds);
            stepCancellationOption(model.stepCancellationOption);
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<String> getStepIds() {
            return stepIds;
        }

        @Override
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepIds(String... stepIds) {
            stepIds(Arrays.asList(stepIds));
            return this;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = StepIdsListCopier.copy(stepIds);
        }

        public final String getStepCancellationOption() {
            return stepCancellationOption;
        }

        @Override
        public final Builder stepCancellationOption(String stepCancellationOption) {
            this.stepCancellationOption = stepCancellationOption;
            return this;
        }

        @Override
        public final Builder stepCancellationOption(StepCancellationOption stepCancellationOption) {
            this.stepCancellationOption(stepCancellationOption == null ? null : stepCancellationOption.toString());
            return this;
        }

        public final void setStepCancellationOption(String stepCancellationOption) {
            this.stepCancellationOption = stepCancellationOption;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CancelStepsRequest build() {
            return new CancelStepsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
