/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This input determines which steps to list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListStepsRequest extends EmrRequest implements ToCopyableBuilder<ListStepsRequest.Builder, ListStepsRequest> {
    private static final SdkField<String> CLUSTER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStepsRequest::clusterId)).setter(setter(Builder::clusterId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterId").build()).build();

    private static final SdkField<List<String>> STEP_STATES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListStepsRequest::stepStatesAsStrings))
            .setter(setter(Builder::stepStatesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STEP_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(ListStepsRequest::stepIds))
            .setter(setter(Builder::stepIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListStepsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ID_FIELD,
            STEP_STATES_FIELD, STEP_IDS_FIELD, MARKER_FIELD));

    private final String clusterId;

    private final List<String> stepStates;

    private final List<String> stepIds;

    private final String marker;

    private ListStepsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.stepStates = builder.stepStates;
        this.stepIds = builder.stepIds;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * The identifier of the cluster for which to list the steps.
     * </p>
     * 
     * @return The identifier of the cluster for which to list the steps.
     */
    public String clusterId() {
        return clusterId;
    }

    /**
     * <p>
     * The filter to limit the step list based on certain states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStepStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filter to limit the step list based on certain states.
     */
    public List<StepState> stepStates() {
        return StepStateListCopier.copyStringToEnum(stepStates);
    }

    /**
     * Returns true if the StepStates property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStepStates() {
        return stepStates != null && !(stepStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter to limit the step list based on certain states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStepStates()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filter to limit the step list based on certain states.
     */
    public List<String> stepStatesAsStrings() {
        return stepStates;
    }

    /**
     * Returns true if the StepIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasStepIds() {
        return stepIds != null && !(stepIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten Step
     * IDs. The character constraint applies to the overall length of the array.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasStepIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten
     *         Step IDs. The character constraint applies to the overall length of the array.
     */
    public List<String> stepIds() {
        return stepIds;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(stepStatesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(stepIds());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListStepsRequest)) {
            return false;
        }
        ListStepsRequest other = (ListStepsRequest) obj;
        return Objects.equals(clusterId(), other.clusterId())
                && Objects.equals(stepStatesAsStrings(), other.stepStatesAsStrings())
                && Objects.equals(stepIds(), other.stepIds()) && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListStepsRequest").add("ClusterId", clusterId()).add("StepStates", stepStatesAsStrings())
                .add("StepIds", stepIds()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterId":
            return Optional.ofNullable(clazz.cast(clusterId()));
        case "StepStates":
            return Optional.ofNullable(clazz.cast(stepStatesAsStrings()));
        case "StepIds":
            return Optional.ofNullable(clazz.cast(stepIds()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListStepsRequest, T> g) {
        return obj -> g.apply((ListStepsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends EmrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListStepsRequest> {
        /**
         * <p>
         * The identifier of the cluster for which to list the steps.
         * </p>
         * 
         * @param clusterId
         *        The identifier of the cluster for which to list the steps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterId(String clusterId);

        /**
         * <p>
         * The filter to limit the step list based on certain states.
         * </p>
         * 
         * @param stepStates
         *        The filter to limit the step list based on certain states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepStatesWithStrings(Collection<String> stepStates);

        /**
         * <p>
         * The filter to limit the step list based on certain states.
         * </p>
         * 
         * @param stepStates
         *        The filter to limit the step list based on certain states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepStatesWithStrings(String... stepStates);

        /**
         * <p>
         * The filter to limit the step list based on certain states.
         * </p>
         * 
         * @param stepStates
         *        The filter to limit the step list based on certain states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepStates(Collection<StepState> stepStates);

        /**
         * <p>
         * The filter to limit the step list based on certain states.
         * </p>
         * 
         * @param stepStates
         *        The filter to limit the step list based on certain states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepStates(StepState... stepStates);

        /**
         * <p>
         * The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten Step
         * IDs. The character constraint applies to the overall length of the array.
         * </p>
         * 
         * @param stepIds
         *        The filter to limit the step list based on the identifier of the steps. You can specify a maximum of
         *        ten Step IDs. The character constraint applies to the overall length of the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepIds(Collection<String> stepIds);

        /**
         * <p>
         * The filter to limit the step list based on the identifier of the steps. You can specify a maximum of ten Step
         * IDs. The character constraint applies to the overall length of the array.
         * </p>
         * 
         * @param stepIds
         *        The filter to limit the step list based on the identifier of the steps. You can specify a maximum of
         *        ten Step IDs. The character constraint applies to the overall length of the array.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepIds(String... stepIds);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param marker
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EmrRequest.BuilderImpl implements Builder {
        private String clusterId;

        private List<String> stepStates = DefaultSdkAutoConstructList.getInstance();

        private List<String> stepIds = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListStepsRequest model) {
            super(model);
            clusterId(model.clusterId);
            stepStatesWithStrings(model.stepStates);
            stepIds(model.stepIds);
            marker(model.marker);
        }

        public final String getClusterId() {
            return clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final Collection<String> getStepStatesAsStrings() {
            return stepStates;
        }

        @Override
        public final Builder stepStatesWithStrings(Collection<String> stepStates) {
            this.stepStates = StepStateListCopier.copy(stepStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStatesWithStrings(String... stepStates) {
            stepStatesWithStrings(Arrays.asList(stepStates));
            return this;
        }

        @Override
        public final Builder stepStates(Collection<StepState> stepStates) {
            this.stepStates = StepStateListCopier.copyEnumToString(stepStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStates(StepState... stepStates) {
            stepStates(Arrays.asList(stepStates));
            return this;
        }

        public final void setStepStatesWithStrings(Collection<String> stepStates) {
            this.stepStates = StepStateListCopier.copy(stepStates);
        }

        public final Collection<String> getStepIds() {
            return stepIds;
        }

        @Override
        public final Builder stepIds(Collection<String> stepIds) {
            this.stepIds = XmlStringListCopier.copy(stepIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepIds(String... stepIds) {
            stepIds(Arrays.asList(stepIds));
            return this;
        }

        public final void setStepIds(Collection<String> stepIds) {
            this.stepIds = XmlStringListCopier.copy(stepIds);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListStepsRequest build() {
            return new ListStepsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
