/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration parameters for an instance fleet modification request.
 * </p>
 * <note>
 * <p>
 * The instance fleet configuration is available only in Amazon EMR versions 4.8.0 and later, excluding 5.0.x versions.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceFleetModifyConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceFleetModifyConfig.Builder, InstanceFleetModifyConfig> {
    private static final SdkField<String> INSTANCE_FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(InstanceFleetModifyConfig::instanceFleetId)).setter(setter(Builder::instanceFleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceFleetId").build()).build();

    private static final SdkField<Integer> TARGET_ON_DEMAND_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstanceFleetModifyConfig::targetOnDemandCapacity)).setter(setter(Builder::targetOnDemandCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetOnDemandCapacity").build())
            .build();

    private static final SdkField<Integer> TARGET_SPOT_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(InstanceFleetModifyConfig::targetSpotCapacity)).setter(setter(Builder::targetSpotCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetSpotCapacity").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_FLEET_ID_FIELD,
            TARGET_ON_DEMAND_CAPACITY_FIELD, TARGET_SPOT_CAPACITY_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceFleetId;

    private final Integer targetOnDemandCapacity;

    private final Integer targetSpotCapacity;

    private InstanceFleetModifyConfig(BuilderImpl builder) {
        this.instanceFleetId = builder.instanceFleetId;
        this.targetOnDemandCapacity = builder.targetOnDemandCapacity;
        this.targetSpotCapacity = builder.targetSpotCapacity;
    }

    /**
     * <p>
     * A unique identifier for the instance fleet.
     * </p>
     * 
     * @return A unique identifier for the instance fleet.
     */
    public String instanceFleetId() {
        return instanceFleetId;
    }

    /**
     * <p>
     * The target capacity of On-Demand units for the instance fleet. For more information see
     * <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.
     * </p>
     * 
     * @return The target capacity of On-Demand units for the instance fleet. For more information see
     *         <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.
     */
    public Integer targetOnDemandCapacity() {
        return targetOnDemandCapacity;
    }

    /**
     * <p>
     * The target capacity of Spot units for the instance fleet. For more information, see
     * <a>InstanceFleetConfig$TargetSpotCapacity</a>.
     * </p>
     * 
     * @return The target capacity of Spot units for the instance fleet. For more information, see
     *         <a>InstanceFleetConfig$TargetSpotCapacity</a>.
     */
    public Integer targetSpotCapacity() {
        return targetSpotCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceFleetId());
        hashCode = 31 * hashCode + Objects.hashCode(targetOnDemandCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(targetSpotCapacity());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceFleetModifyConfig)) {
            return false;
        }
        InstanceFleetModifyConfig other = (InstanceFleetModifyConfig) obj;
        return Objects.equals(instanceFleetId(), other.instanceFleetId())
                && Objects.equals(targetOnDemandCapacity(), other.targetOnDemandCapacity())
                && Objects.equals(targetSpotCapacity(), other.targetSpotCapacity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("InstanceFleetModifyConfig").add("InstanceFleetId", instanceFleetId())
                .add("TargetOnDemandCapacity", targetOnDemandCapacity()).add("TargetSpotCapacity", targetSpotCapacity()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceFleetId":
            return Optional.ofNullable(clazz.cast(instanceFleetId()));
        case "TargetOnDemandCapacity":
            return Optional.ofNullable(clazz.cast(targetOnDemandCapacity()));
        case "TargetSpotCapacity":
            return Optional.ofNullable(clazz.cast(targetSpotCapacity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceFleetModifyConfig, T> g) {
        return obj -> g.apply((InstanceFleetModifyConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceFleetModifyConfig> {
        /**
         * <p>
         * A unique identifier for the instance fleet.
         * </p>
         * 
         * @param instanceFleetId
         *        A unique identifier for the instance fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceFleetId(String instanceFleetId);

        /**
         * <p>
         * The target capacity of On-Demand units for the instance fleet. For more information see
         * <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.
         * </p>
         * 
         * @param targetOnDemandCapacity
         *        The target capacity of On-Demand units for the instance fleet. For more information see
         *        <a>InstanceFleetConfig$TargetOnDemandCapacity</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetOnDemandCapacity(Integer targetOnDemandCapacity);

        /**
         * <p>
         * The target capacity of Spot units for the instance fleet. For more information, see
         * <a>InstanceFleetConfig$TargetSpotCapacity</a>.
         * </p>
         * 
         * @param targetSpotCapacity
         *        The target capacity of Spot units for the instance fleet. For more information, see
         *        <a>InstanceFleetConfig$TargetSpotCapacity</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetSpotCapacity(Integer targetSpotCapacity);
    }

    static final class BuilderImpl implements Builder {
        private String instanceFleetId;

        private Integer targetOnDemandCapacity;

        private Integer targetSpotCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceFleetModifyConfig model) {
            instanceFleetId(model.instanceFleetId);
            targetOnDemandCapacity(model.targetOnDemandCapacity);
            targetSpotCapacity(model.targetSpotCapacity);
        }

        public final String getInstanceFleetId() {
            return instanceFleetId;
        }

        @Override
        public final Builder instanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
            return this;
        }

        public final void setInstanceFleetId(String instanceFleetId) {
            this.instanceFleetId = instanceFleetId;
        }

        public final Integer getTargetOnDemandCapacity() {
            return targetOnDemandCapacity;
        }

        @Override
        public final Builder targetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
            return this;
        }

        public final void setTargetOnDemandCapacity(Integer targetOnDemandCapacity) {
            this.targetOnDemandCapacity = targetOnDemandCapacity;
        }

        public final Integer getTargetSpotCapacity() {
            return targetSpotCapacity;
        }

        @Override
        public final Builder targetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
            return this;
        }

        public final void setTargetSpotCapacity(Integer targetSpotCapacity) {
            this.targetSpotCapacity = targetSpotCapacity;
        }

        @Override
        public InstanceFleetModifyConfig build() {
            return new InstanceFleetModifyConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
