/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon EBS configuration of a cluster instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EbsConfiguration.Builder, EbsConfiguration> {
    private static final SdkField<List<EbsBlockDeviceConfig>> EBS_BLOCK_DEVICE_CONFIGS_FIELD = SdkField
            .<List<EbsBlockDeviceConfig>> builder(MarshallingType.LIST)
            .getter(getter(EbsConfiguration::ebsBlockDeviceConfigs))
            .setter(setter(Builder::ebsBlockDeviceConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsBlockDeviceConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EbsBlockDeviceConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(EbsBlockDeviceConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(EbsConfiguration::ebsOptimized)).setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EBS_BLOCK_DEVICE_CONFIGS_FIELD, EBS_OPTIMIZED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs;

    private final Boolean ebsOptimized;

    private EbsConfiguration(BuilderImpl builder) {
        this.ebsBlockDeviceConfigs = builder.ebsBlockDeviceConfigs;
        this.ebsOptimized = builder.ebsOptimized;
    }

    /**
     * Returns true if the EbsBlockDeviceConfigs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasEbsBlockDeviceConfigs() {
        return ebsBlockDeviceConfigs != null && !(ebsBlockDeviceConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of Amazon EBS volume specifications attached to a cluster instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEbsBlockDeviceConfigs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of Amazon EBS volume specifications attached to a cluster instance.
     */
    public List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs() {
        return ebsBlockDeviceConfigs;
    }

    /**
     * <p>
     * Indicates whether an Amazon EBS volume is EBS-optimized.
     * </p>
     * 
     * @return Indicates whether an Amazon EBS volume is EBS-optimized.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ebsBlockDeviceConfigs());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsConfiguration)) {
            return false;
        }
        EbsConfiguration other = (EbsConfiguration) obj;
        return Objects.equals(ebsBlockDeviceConfigs(), other.ebsBlockDeviceConfigs())
                && Objects.equals(ebsOptimized(), other.ebsOptimized());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EbsConfiguration").add("EbsBlockDeviceConfigs", ebsBlockDeviceConfigs())
                .add("EbsOptimized", ebsOptimized()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EbsBlockDeviceConfigs":
            return Optional.ofNullable(clazz.cast(ebsBlockDeviceConfigs()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsConfiguration, T> g) {
        return obj -> g.apply((EbsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsConfiguration> {
        /**
         * <p>
         * An array of Amazon EBS volume specifications attached to a cluster instance.
         * </p>
         * 
         * @param ebsBlockDeviceConfigs
         *        An array of Amazon EBS volume specifications attached to a cluster instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> ebsBlockDeviceConfigs);

        /**
         * <p>
         * An array of Amazon EBS volume specifications attached to a cluster instance.
         * </p>
         * 
         * @param ebsBlockDeviceConfigs
         *        An array of Amazon EBS volume specifications attached to a cluster instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsBlockDeviceConfigs(EbsBlockDeviceConfig... ebsBlockDeviceConfigs);

        /**
         * <p>
         * An array of Amazon EBS volume specifications attached to a cluster instance.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EbsBlockDeviceConfig>.Builder} avoiding the
         * need to create one manually via {@link List<EbsBlockDeviceConfig>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EbsBlockDeviceConfig>.Builder#build()} is called immediately
         * and its result is passed to {@link #ebsBlockDeviceConfigs(List<EbsBlockDeviceConfig>)}.
         * 
         * @param ebsBlockDeviceConfigs
         *        a consumer that will call methods on {@link List<EbsBlockDeviceConfig>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ebsBlockDeviceConfigs(List<EbsBlockDeviceConfig>)
         */
        Builder ebsBlockDeviceConfigs(Consumer<EbsBlockDeviceConfig.Builder>... ebsBlockDeviceConfigs);

        /**
         * <p>
         * Indicates whether an Amazon EBS volume is EBS-optimized.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether an Amazon EBS volume is EBS-optimized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);
    }

    static final class BuilderImpl implements Builder {
        private List<EbsBlockDeviceConfig> ebsBlockDeviceConfigs = DefaultSdkAutoConstructList.getInstance();

        private Boolean ebsOptimized;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsConfiguration model) {
            ebsBlockDeviceConfigs(model.ebsBlockDeviceConfigs);
            ebsOptimized(model.ebsOptimized);
        }

        public final Collection<EbsBlockDeviceConfig.Builder> getEbsBlockDeviceConfigs() {
            return ebsBlockDeviceConfigs != null ? ebsBlockDeviceConfigs.stream().map(EbsBlockDeviceConfig::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder ebsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig> ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs = EbsBlockDeviceConfigListCopier.copy(ebsBlockDeviceConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDeviceConfigs(EbsBlockDeviceConfig... ebsBlockDeviceConfigs) {
            ebsBlockDeviceConfigs(Arrays.asList(ebsBlockDeviceConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ebsBlockDeviceConfigs(Consumer<EbsBlockDeviceConfig.Builder>... ebsBlockDeviceConfigs) {
            ebsBlockDeviceConfigs(Stream.of(ebsBlockDeviceConfigs)
                    .map(c -> EbsBlockDeviceConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setEbsBlockDeviceConfigs(Collection<EbsBlockDeviceConfig.BuilderImpl> ebsBlockDeviceConfigs) {
            this.ebsBlockDeviceConfigs = EbsBlockDeviceConfigListCopier.copyFromBuilder(ebsBlockDeviceConfigs);
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public EbsConfiguration build() {
            return new EbsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
