/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.emr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration of requested EBS block device associated with the instance group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EbsBlockDevice implements SdkPojo, Serializable, ToCopyableBuilder<EbsBlockDevice.Builder, EbsBlockDevice> {
    private static final SdkField<VolumeSpecification> VOLUME_SPECIFICATION_FIELD = SdkField
            .<VolumeSpecification> builder(MarshallingType.SDK_POJO).getter(getter(EbsBlockDevice::volumeSpecification))
            .setter(setter(Builder::volumeSpecification)).constructor(VolumeSpecification::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSpecification").build())
            .build();

    private static final SdkField<String> DEVICE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(EbsBlockDevice::device)).setter(setter(Builder::device))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Device").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_SPECIFICATION_FIELD,
            DEVICE_FIELD));

    private static final long serialVersionUID = 1L;

    private final VolumeSpecification volumeSpecification;

    private final String device;

    private EbsBlockDevice(BuilderImpl builder) {
        this.volumeSpecification = builder.volumeSpecification;
        this.device = builder.device;
    }

    /**
     * <p>
     * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume
     * attached to an EC2 instance in the cluster.
     * </p>
     * 
     * @return EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS
     *         volume attached to an EC2 instance in the cluster.
     */
    public VolumeSpecification volumeSpecification() {
        return volumeSpecification;
    }

    /**
     * <p>
     * The device name that is exposed to the instance, such as /dev/sdh.
     * </p>
     * 
     * @return The device name that is exposed to the instance, such as /dev/sdh.
     */
    public String device() {
        return device;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(volumeSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(device());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EbsBlockDevice)) {
            return false;
        }
        EbsBlockDevice other = (EbsBlockDevice) obj;
        return Objects.equals(volumeSpecification(), other.volumeSpecification()) && Objects.equals(device(), other.device());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("EbsBlockDevice").add("VolumeSpecification", volumeSpecification()).add("Device", device())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VolumeSpecification":
            return Optional.ofNullable(clazz.cast(volumeSpecification()));
        case "Device":
            return Optional.ofNullable(clazz.cast(device()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EbsBlockDevice, T> g) {
        return obj -> g.apply((EbsBlockDevice) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EbsBlockDevice> {
        /**
         * <p>
         * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume
         * attached to an EC2 instance in the cluster.
         * </p>
         * 
         * @param volumeSpecification
         *        EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS
         *        volume attached to an EC2 instance in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeSpecification(VolumeSpecification volumeSpecification);

        /**
         * <p>
         * EBS volume specifications such as volume type, IOPS, and size (GiB) that will be requested for the EBS volume
         * attached to an EC2 instance in the cluster.
         * </p>
         * This is a convenience that creates an instance of the {@link VolumeSpecification.Builder} avoiding the need
         * to create one manually via {@link VolumeSpecification#builder()}.
         *
         * When the {@link Consumer} completes, {@link VolumeSpecification.Builder#build()} is called immediately and
         * its result is passed to {@link #volumeSpecification(VolumeSpecification)}.
         * 
         * @param volumeSpecification
         *        a consumer that will call methods on {@link VolumeSpecification.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #volumeSpecification(VolumeSpecification)
         */
        default Builder volumeSpecification(Consumer<VolumeSpecification.Builder> volumeSpecification) {
            return volumeSpecification(VolumeSpecification.builder().applyMutation(volumeSpecification).build());
        }

        /**
         * <p>
         * The device name that is exposed to the instance, such as /dev/sdh.
         * </p>
         * 
         * @param device
         *        The device name that is exposed to the instance, such as /dev/sdh.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder device(String device);
    }

    static final class BuilderImpl implements Builder {
        private VolumeSpecification volumeSpecification;

        private String device;

        private BuilderImpl() {
        }

        private BuilderImpl(EbsBlockDevice model) {
            volumeSpecification(model.volumeSpecification);
            device(model.device);
        }

        public final VolumeSpecification.Builder getVolumeSpecification() {
            return volumeSpecification != null ? volumeSpecification.toBuilder() : null;
        }

        @Override
        public final Builder volumeSpecification(VolumeSpecification volumeSpecification) {
            this.volumeSpecification = volumeSpecification;
            return this;
        }

        public final void setVolumeSpecification(VolumeSpecification.BuilderImpl volumeSpecification) {
            this.volumeSpecification = volumeSpecification != null ? volumeSpecification.build() : null;
        }

        public final String getDevice() {
            return device;
        }

        @Override
        public final Builder device(String device) {
            this.device = device;
            return this;
        }

        public final void setDevice(String device) {
            this.device = device;
        }

        @Override
        public EbsBlockDevice build() {
            return new EbsBlockDevice(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
