/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ScalingAction;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ScalingActionMarshaller {
    private static final MarshallingInfo<String> MARKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Market").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> SIMPLESCALINGPOLICYCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SimpleScalingPolicyConfiguration").isBinary(false).build();
    private static final ScalingActionMarshaller INSTANCE = new ScalingActionMarshaller();

    private ScalingActionMarshaller() {
    }

    public static ScalingActionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ScalingAction scalingAction, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)scalingAction, (String)"scalingAction");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)scalingAction.marketString(), MARKET_BINDING);
            protocolMarshaller.marshall((Object)scalingAction.simpleScalingPolicyConfiguration(), SIMPLESCALINGPOLICYCONFIGURATION_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

