/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.ModifyInstanceGroupsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ModifyInstanceGroupsRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCEGROUPS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroups").isBinary(false).build();
    private static final ModifyInstanceGroupsRequestModelMarshaller INSTANCE = new ModifyInstanceGroupsRequestModelMarshaller();

    private ModifyInstanceGroupsRequestModelMarshaller() {
    }

    public static ModifyInstanceGroupsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ModifyInstanceGroupsRequest modifyInstanceGroupsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)modifyInstanceGroupsRequest), (String)"modifyInstanceGroupsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)modifyInstanceGroupsRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall(modifyInstanceGroupsRequest.instanceGroups(), INSTANCEGROUPS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

