/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.ListInstancesRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListInstancesRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroupId").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCEGROUPTYPES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroupTypes").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEFLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceFleetId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEFLEETTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceFleetType").isBinary(false).build();
    private static final MarshallingInfo<List> INSTANCESTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceStates").isBinary(false).build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Marker").isBinary(false).build();
    private static final ListInstancesRequestModelMarshaller INSTANCE = new ListInstancesRequestModelMarshaller();

    private ListInstancesRequestModelMarshaller() {
    }

    public static ListInstancesRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListInstancesRequest listInstancesRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listInstancesRequest), (String)"listInstancesRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listInstancesRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall((Object)listInstancesRequest.instanceGroupId(), INSTANCEGROUPID_BINDING);
            protocolMarshaller.marshall(listInstancesRequest.instanceGroupTypesStrings(), INSTANCEGROUPTYPES_BINDING);
            protocolMarshaller.marshall((Object)listInstancesRequest.instanceFleetId(), INSTANCEFLEETID_BINDING);
            protocolMarshaller.marshall((Object)listInstancesRequest.instanceFleetTypeString(), INSTANCEFLEETTYPE_BINDING);
            protocolMarshaller.marshall(listInstancesRequest.instanceStatesStrings(), INSTANCESTATES_BINDING);
            protocolMarshaller.marshall((Object)listInstancesRequest.marker(), MARKER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

