/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.Instance;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class InstanceMarshaller {
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Id").isBinary(false).build();
    private static final MarshallingInfo<String> EC2INSTANCEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Ec2InstanceId").isBinary(false).build();
    private static final MarshallingInfo<String> PUBLICDNSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicDnsName").isBinary(false).build();
    private static final MarshallingInfo<String> PUBLICIPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PublicIpAddress").isBinary(false).build();
    private static final MarshallingInfo<String> PRIVATEDNSNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateDnsName").isBinary(false).build();
    private static final MarshallingInfo<String> PRIVATEIPADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PrivateIpAddress").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEGROUPID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceGroupId").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCEFLEETID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceFleetId").isBinary(false).build();
    private static final MarshallingInfo<String> MARKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Market").isBinary(false).build();
    private static final MarshallingInfo<String> INSTANCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceType").isBinary(false).build();
    private static final MarshallingInfo<List> EBSVOLUMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsVolumes").isBinary(false).build();
    private static final InstanceMarshaller INSTANCE = new InstanceMarshaller();

    private InstanceMarshaller() {
    }

    public static InstanceMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Instance instance, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)instance, (String)"instance");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)instance.id(), ID_BINDING);
            protocolMarshaller.marshall((Object)instance.ec2InstanceId(), EC2INSTANCEID_BINDING);
            protocolMarshaller.marshall((Object)instance.publicDnsName(), PUBLICDNSNAME_BINDING);
            protocolMarshaller.marshall((Object)instance.publicIpAddress(), PUBLICIPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)instance.privateDnsName(), PRIVATEDNSNAME_BINDING);
            protocolMarshaller.marshall((Object)instance.privateIpAddress(), PRIVATEIPADDRESS_BINDING);
            protocolMarshaller.marshall((Object)instance.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)instance.instanceGroupId(), INSTANCEGROUPID_BINDING);
            protocolMarshaller.marshall((Object)instance.instanceFleetId(), INSTANCEFLEETID_BINDING);
            protocolMarshaller.marshall((Object)instance.marketString(), MARKET_BINDING);
            protocolMarshaller.marshall((Object)instance.instanceType(), INSTANCETYPE_BINDING);
            protocolMarshaller.marshall(instance.ebsVolumes(), EBSVOLUMES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

