/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.InstanceGroupConfig;
import software.amazon.awssdk.services.emr.transform.AutoScalingPolicyUnmarshaller;
import software.amazon.awssdk.services.emr.transform.ConfigurationUnmarshaller;
import software.amazon.awssdk.services.emr.transform.EbsConfigurationUnmarshaller;

public class InstanceGroupConfigUnmarshaller
implements Unmarshaller<InstanceGroupConfig, JsonUnmarshallerContext> {
    private static final InstanceGroupConfigUnmarshaller INSTANCE = new InstanceGroupConfigUnmarshaller();

    public InstanceGroupConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        InstanceGroupConfig.Builder instanceGroupConfigBuilder = InstanceGroupConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    instanceGroupConfigBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Market", targetDepth)) {
                    context.nextToken();
                    instanceGroupConfigBuilder.market((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceRole", targetDepth)) {
                    context.nextToken();
                    instanceGroupConfigBuilder.instanceRole((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("BidPrice", targetDepth)) {
                    context.nextToken();
                    instanceGroupConfigBuilder.bidPrice((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceType", targetDepth)) {
                    context.nextToken();
                    instanceGroupConfigBuilder.instanceType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("InstanceCount", targetDepth)) {
                    context.nextToken();
                    instanceGroupConfigBuilder.instanceCount((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("Configurations", targetDepth)) {
                    context.nextToken();
                    instanceGroupConfigBuilder.configurations(new ListUnmarshaller((Unmarshaller)ConfigurationUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("EbsConfiguration", targetDepth)) {
                    context.nextToken();
                    instanceGroupConfigBuilder.ebsConfiguration(EbsConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("AutoScalingPolicy", targetDepth)) {
                    context.nextToken();
                    instanceGroupConfigBuilder.autoScalingPolicy(AutoScalingPolicyUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (InstanceGroupConfig)instanceGroupConfigBuilder.build();
    }

    public static InstanceGroupConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

