/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.EbsVolume;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EbsVolumeMarshaller {
    private static final MarshallingInfo<String> DEVICE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Device").isBinary(false).build();
    private static final MarshallingInfo<String> VOLUMEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeId").isBinary(false).build();
    private static final EbsVolumeMarshaller INSTANCE = new EbsVolumeMarshaller();

    private EbsVolumeMarshaller() {
    }

    public static EbsVolumeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EbsVolume ebsVolume, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ebsVolume, (String)"ebsVolume");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ebsVolume.device(), DEVICE_BINDING);
            protocolMarshaller.marshall((Object)ebsVolume.volumeId(), VOLUMEID_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

