/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.EbsBlockDeviceConfig;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class EbsBlockDeviceConfigMarshaller {
    private static final MarshallingInfo<StructuredPojo> VOLUMESPECIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeSpecification").isBinary(false).build();
    private static final MarshallingInfo<Integer> VOLUMESPERINSTANCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumesPerInstance").isBinary(false).build();
    private static final EbsBlockDeviceConfigMarshaller INSTANCE = new EbsBlockDeviceConfigMarshaller();

    private EbsBlockDeviceConfigMarshaller() {
    }

    public static EbsBlockDeviceConfigMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(EbsBlockDeviceConfig ebsBlockDeviceConfig, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)ebsBlockDeviceConfig, (String)"ebsBlockDeviceConfig");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)ebsBlockDeviceConfig.volumeSpecification(), VOLUMESPECIFICATION_BINDING);
            protocolMarshaller.marshall((Object)ebsBlockDeviceConfig.volumesPerInstance(), VOLUMESPERINSTANCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

