/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.Configuration;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ConfigurationMarshaller {
    private static final MarshallingInfo<String> CLASSIFICATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Classification").isBinary(false).build();
    private static final MarshallingInfo<List> CONFIGURATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Configurations").isBinary(false).build();
    private static final MarshallingInfo<Map> PROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Properties").isBinary(false).build();
    private static final ConfigurationMarshaller INSTANCE = new ConfigurationMarshaller();

    private ConfigurationMarshaller() {
    }

    public static ConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Configuration configuration, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)configuration, (String)"configuration");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)configuration.classification(), CLASSIFICATION_BINDING);
            protocolMarshaller.marshall(configuration.configurations(), CONFIGURATIONS_BINDING);
            protocolMarshaller.marshall(configuration.properties(), PROPERTIES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

