/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.AutoScalingPolicyDescription;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class AutoScalingPolicyDescriptionMarshaller {
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> CONSTRAINTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Constraints").isBinary(false).build();
    private static final MarshallingInfo<List> RULES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Rules").isBinary(false).build();
    private static final AutoScalingPolicyDescriptionMarshaller INSTANCE = new AutoScalingPolicyDescriptionMarshaller();

    private AutoScalingPolicyDescriptionMarshaller() {
    }

    public static AutoScalingPolicyDescriptionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutoScalingPolicyDescription autoScalingPolicyDescription, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)autoScalingPolicyDescription, (String)"autoScalingPolicyDescription");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)autoScalingPolicyDescription.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)autoScalingPolicyDescription.constraints(), CONSTRAINTS_BINDING);
            protocolMarshaller.marshall(autoScalingPolicyDescription.rules(), RULES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

