/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.emr.EMRAsyncClient;
import software.amazon.awssdk.services.emr.model.ClusterSummary;
import software.amazon.awssdk.services.emr.model.ListClustersRequest;
import software.amazon.awssdk.services.emr.model.ListClustersResponse;

public class ListClustersPublisher
implements SdkPublisher<ListClustersResponse> {
    private final EMRAsyncClient client;
    private final ListClustersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListClustersPublisher(EMRAsyncClient client, ListClustersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListClustersPublisher(EMRAsyncClient client, ListClustersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListClustersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListClustersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final SdkPublisher<ClusterSummary> clusters() {
        Function<ListClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.clusters() != null) {
                return response.clusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsPublisher((AsyncPageFetcher)new ListClustersResponseFetcher(), getIterator, this.isLastPage);
    }

    public final ListClustersPublisher resume(ListClustersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListClustersPublisher(this.client, (ListClustersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new ListClustersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListClustersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListClustersResponseFetcher
    implements AsyncPageFetcher<ListClustersResponse> {
        private ListClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListClustersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public CompletableFuture<ListClustersResponse> nextPage(ListClustersResponse previousPage) {
            if (previousPage == null) {
                return ListClustersPublisher.this.client.listClusters(ListClustersPublisher.this.firstRequest);
            }
            return ListClustersPublisher.this.client.listClusters((ListClustersRequest)((Object)ListClustersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

