/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.ClusterStatus;
import software.amazon.awssdk.services.emr.transform.ClusterSummaryMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, ClusterSummary> {
    private final String id;
    private final String name;
    private final ClusterStatus status;
    private final Integer normalizedInstanceHours;

    private ClusterSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.normalizedInstanceHours = builder.normalizedInstanceHours;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public ClusterStatus status() {
        return this.status;
    }

    public Integer normalizedInstanceHours() {
        return this.normalizedInstanceHours;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.normalizedInstanceHours());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSummary)) {
            return false;
        }
        ClusterSummary other = (ClusterSummary)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.normalizedInstanceHours(), other.normalizedInstanceHours());
    }

    public String toString() {
        return ToString.builder((String)"ClusterSummary").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("NormalizedInstanceHours", (Object)this.normalizedInstanceHours()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.of(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "NormalizedInstanceHours": {
                return Optional.of(clazz.cast(this.normalizedInstanceHours()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private ClusterStatus status;
        private Integer normalizedInstanceHours;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSummary model) {
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.normalizedInstanceHours(model.normalizedInstanceHours);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ClusterStatus.Builder getStatus() {
            return this.status != null ? this.status.toBuilder() : null;
        }

        @Override
        public final Builder status(ClusterStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(ClusterStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        public final Integer getNormalizedInstanceHours() {
            return this.normalizedInstanceHours;
        }

        @Override
        public final Builder normalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
            return this;
        }

        public final void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
            this.normalizedInstanceHours = normalizedInstanceHours;
        }

        public ClusterSummary build() {
            return new ClusterSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterSummary> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(ClusterStatus var1);

        default public Builder status(Consumer<ClusterStatus.Builder> status) {
            return this.status((ClusterStatus)((ClusterStatus.Builder)ClusterStatus.builder().apply(status)).build());
        }

        public Builder normalizedInstanceHours(Integer var1);
    }
}

