/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.ScalingConstraints;

@SdkInternalApi
public class ScalingConstraintsMarshaller {
    private static final MarshallingInfo<Integer> MINCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MinCapacity").build();
    private static final MarshallingInfo<Integer> MAXCAPACITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MaxCapacity").build();
    private static final ScalingConstraintsMarshaller INSTANCE = new ScalingConstraintsMarshaller();

    public static ScalingConstraintsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ScalingConstraints scalingConstraints, ProtocolMarshaller protocolMarshaller) {
        if (scalingConstraints == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)scalingConstraints.minCapacity(), MINCAPACITY_BINDING);
            protocolMarshaller.marshall((Object)scalingConstraints.maxCapacity(), MAXCAPACITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

