/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.InstanceFleet;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsRequest;
import software.amazon.awssdk.services.emr.model.ListInstanceFleetsResponse;

public final class ListInstanceFleetsPaginator
implements SdkIterable<ListInstanceFleetsResponse> {
    private final EMRClient client;
    private final ListInstanceFleetsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListInstanceFleetsPaginator(EMRClient client, ListInstanceFleetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListInstanceFleetsResponseFetcher();
    }

    public Iterator<ListInstanceFleetsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<InstanceFleet> instanceFleets() {
        Function<ListInstanceFleetsResponse, Iterator> getIterator = response -> response != null ? response.instanceFleets().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListInstanceFleetsResponseFetcher
    implements NextPageFetcher<ListInstanceFleetsResponse> {
        private ListInstanceFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListInstanceFleetsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListInstanceFleetsResponse nextPage(ListInstanceFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListInstanceFleetsPaginator.this.client.listInstanceFleets(ListInstanceFleetsPaginator.this.firstRequest);
            }
            return ListInstanceFleetsPaginator.this.client.listInstanceFleets((ListInstanceFleetsRequest)((Object)ListInstanceFleetsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

