/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.Command;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsRequest;
import software.amazon.awssdk.services.emr.model.ListBootstrapActionsResponse;

public final class ListBootstrapActionsPaginator
implements SdkIterable<ListBootstrapActionsResponse> {
    private final EMRClient client;
    private final ListBootstrapActionsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListBootstrapActionsPaginator(EMRClient client, ListBootstrapActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListBootstrapActionsResponseFetcher();
    }

    public Iterator<ListBootstrapActionsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Command> bootstrapActions() {
        Function<ListBootstrapActionsResponse, Iterator> getIterator = response -> response != null ? response.bootstrapActions().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListBootstrapActionsResponseFetcher
    implements NextPageFetcher<ListBootstrapActionsResponse> {
        private ListBootstrapActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListBootstrapActionsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListBootstrapActionsResponse nextPage(ListBootstrapActionsResponse previousPage) {
            if (previousPage == null) {
                return ListBootstrapActionsPaginator.this.client.listBootstrapActions(ListBootstrapActionsPaginator.this.firstRequest);
            }
            return ListBootstrapActionsPaginator.this.client.listBootstrapActions((ListBootstrapActionsRequest)((Object)ListBootstrapActionsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

