/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.emr.model.Command;
import software.amazon.awssdk.services.emr.model.CommandListCopier;
import software.amazon.awssdk.services.emr.model.EMRResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListBootstrapActionsResponse
extends EMRResponse
implements ToCopyableBuilder<Builder, ListBootstrapActionsResponse> {
    private final List<Command> bootstrapActions;
    private final String marker;

    private ListBootstrapActionsResponse(BuilderImpl builder) {
        super(builder);
        this.bootstrapActions = builder.bootstrapActions;
        this.marker = builder.marker;
    }

    public List<Command> bootstrapActions() {
        return this.bootstrapActions;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.bootstrapActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListBootstrapActionsResponse)) {
            return false;
        }
        ListBootstrapActionsResponse other = (ListBootstrapActionsResponse)((Object)obj);
        return Objects.equals(this.bootstrapActions(), other.bootstrapActions()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListBootstrapActionsResponse").add("BootstrapActions", this.bootstrapActions()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BootstrapActions": {
                return Optional.of(clazz.cast(this.bootstrapActions()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRResponse.BuilderImpl
    implements Builder {
        private List<Command> bootstrapActions;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListBootstrapActionsResponse model) {
            this.bootstrapActions(model.bootstrapActions);
            this.marker(model.marker);
        }

        public final Collection<Command.Builder> getBootstrapActions() {
            return this.bootstrapActions != null ? (Collection)this.bootstrapActions.stream().map(Command::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder bootstrapActions(Collection<Command> bootstrapActions) {
            this.bootstrapActions = CommandListCopier.copy(bootstrapActions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder bootstrapActions(Command ... bootstrapActions) {
            this.bootstrapActions(Arrays.asList(bootstrapActions));
            return this;
        }

        public final void setBootstrapActions(Collection<Command.BuilderImpl> bootstrapActions) {
            this.bootstrapActions = CommandListCopier.copyFromBuilder(bootstrapActions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListBootstrapActionsResponse build() {
            return new ListBootstrapActionsResponse(this);
        }
    }

    public static interface Builder
    extends EMRResponse.Builder,
    CopyableBuilder<Builder, ListBootstrapActionsResponse> {
        public Builder bootstrapActions(Collection<Command> var1);

        public Builder bootstrapActions(Command ... var1);

        public Builder marker(String var1);
    }
}

