/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceGroupState;
import software.amazon.awssdk.services.emr.model.InstanceGroupStateChangeReason;
import software.amazon.awssdk.services.emr.model.InstanceGroupTimeline;
import software.amazon.awssdk.services.emr.transform.InstanceGroupStatusMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceGroupStatus
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceGroupStatus> {
    private final String state;
    private final InstanceGroupStateChangeReason stateChangeReason;
    private final InstanceGroupTimeline timeline;

    private InstanceGroupStatus(BuilderImpl builder) {
        this.state = builder.state;
        this.stateChangeReason = builder.stateChangeReason;
        this.timeline = builder.timeline;
    }

    public InstanceGroupState state() {
        return InstanceGroupState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public InstanceGroupStateChangeReason stateChangeReason() {
        return this.stateChangeReason;
    }

    public InstanceGroupTimeline timeline() {
        return this.timeline;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeline());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupStatus)) {
            return false;
        }
        InstanceGroupStatus other = (InstanceGroupStatus)obj;
        return Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.stateChangeReason(), other.stateChangeReason()) && Objects.equals(this.timeline(), other.timeline());
    }

    public String toString() {
        return ToString.builder((String)"InstanceGroupStatus").add("State", (Object)this.stateString()).add("StateChangeReason", (Object)this.stateChangeReason()).add("Timeline", (Object)this.timeline()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "StateChangeReason": {
                return Optional.of(clazz.cast(this.stateChangeReason()));
            }
            case "Timeline": {
                return Optional.of(clazz.cast(this.timeline()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceGroupStatusMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String state;
        private InstanceGroupStateChangeReason stateChangeReason;
        private InstanceGroupTimeline timeline;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupStatus model) {
            this.state(model.state);
            this.stateChangeReason(model.stateChangeReason);
            this.timeline(model.timeline);
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceGroupState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final InstanceGroupStateChangeReason.Builder getStateChangeReason() {
            return this.stateChangeReason != null ? this.stateChangeReason.toBuilder() : null;
        }

        @Override
        public final Builder stateChangeReason(InstanceGroupStateChangeReason stateChangeReason) {
            this.stateChangeReason = stateChangeReason;
            return this;
        }

        public final void setStateChangeReason(InstanceGroupStateChangeReason.BuilderImpl stateChangeReason) {
            this.stateChangeReason = stateChangeReason != null ? stateChangeReason.build() : null;
        }

        public final InstanceGroupTimeline.Builder getTimeline() {
            return this.timeline != null ? this.timeline.toBuilder() : null;
        }

        @Override
        public final Builder timeline(InstanceGroupTimeline timeline) {
            this.timeline = timeline;
            return this;
        }

        public final void setTimeline(InstanceGroupTimeline.BuilderImpl timeline) {
            this.timeline = timeline != null ? timeline.build() : null;
        }

        public InstanceGroupStatus build() {
            return new InstanceGroupStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceGroupStatus> {
        public Builder state(String var1);

        public Builder state(InstanceGroupState var1);

        public Builder stateChangeReason(InstanceGroupStateChangeReason var1);

        default public Builder stateChangeReason(Consumer<InstanceGroupStateChangeReason.Builder> stateChangeReason) {
            return this.stateChangeReason((InstanceGroupStateChangeReason)((InstanceGroupStateChangeReason.Builder)InstanceGroupStateChangeReason.builder().apply(stateChangeReason)).build());
        }

        public Builder timeline(InstanceGroupTimeline var1);

        default public Builder timeline(Consumer<InstanceGroupTimeline.Builder> timeline) {
            return this.timeline((InstanceGroupTimeline)((InstanceGroupTimeline.Builder)InstanceGroupTimeline.builder().apply(timeline)).build());
        }
    }
}

