/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.emr.model.InstanceGroupState;
import software.amazon.awssdk.services.emr.model.InstanceRoleType;
import software.amazon.awssdk.services.emr.model.MarketType;
import software.amazon.awssdk.services.emr.transform.InstanceGroupDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InstanceGroupDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, InstanceGroupDetail> {
    private final String instanceGroupId;
    private final String name;
    private final String market;
    private final String instanceRole;
    private final String bidPrice;
    private final String instanceType;
    private final Integer instanceRequestCount;
    private final Integer instanceRunningCount;
    private final String state;
    private final String lastStateChangeReason;
    private final Instant creationDateTime;
    private final Instant startDateTime;
    private final Instant readyDateTime;
    private final Instant endDateTime;

    private InstanceGroupDetail(BuilderImpl builder) {
        this.instanceGroupId = builder.instanceGroupId;
        this.name = builder.name;
        this.market = builder.market;
        this.instanceRole = builder.instanceRole;
        this.bidPrice = builder.bidPrice;
        this.instanceType = builder.instanceType;
        this.instanceRequestCount = builder.instanceRequestCount;
        this.instanceRunningCount = builder.instanceRunningCount;
        this.state = builder.state;
        this.lastStateChangeReason = builder.lastStateChangeReason;
        this.creationDateTime = builder.creationDateTime;
        this.startDateTime = builder.startDateTime;
        this.readyDateTime = builder.readyDateTime;
        this.endDateTime = builder.endDateTime;
    }

    public String instanceGroupId() {
        return this.instanceGroupId;
    }

    public String name() {
        return this.name;
    }

    public MarketType market() {
        return MarketType.fromValue(this.market);
    }

    public String marketString() {
        return this.market;
    }

    public InstanceRoleType instanceRole() {
        return InstanceRoleType.fromValue(this.instanceRole);
    }

    public String instanceRoleString() {
        return this.instanceRole;
    }

    public String bidPrice() {
        return this.bidPrice;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public Integer instanceRequestCount() {
        return this.instanceRequestCount;
    }

    public Integer instanceRunningCount() {
        return this.instanceRunningCount;
    }

    public InstanceGroupState state() {
        return InstanceGroupState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public String lastStateChangeReason() {
        return this.lastStateChangeReason;
    }

    public Instant creationDateTime() {
        return this.creationDateTime;
    }

    public Instant startDateTime() {
        return this.startDateTime;
    }

    public Instant readyDateTime() {
        return this.readyDateTime;
    }

    public Instant endDateTime() {
        return this.endDateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.marketString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRoleString());
        hashCode = 31 * hashCode + Objects.hashCode(this.bidPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequestCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRunningCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastStateChangeReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.readyDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDateTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceGroupDetail)) {
            return false;
        }
        InstanceGroupDetail other = (InstanceGroupDetail)obj;
        return Objects.equals(this.instanceGroupId(), other.instanceGroupId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.marketString(), other.marketString()) && Objects.equals(this.instanceRoleString(), other.instanceRoleString()) && Objects.equals(this.bidPrice(), other.bidPrice()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.instanceRequestCount(), other.instanceRequestCount()) && Objects.equals(this.instanceRunningCount(), other.instanceRunningCount()) && Objects.equals(this.stateString(), other.stateString()) && Objects.equals(this.lastStateChangeReason(), other.lastStateChangeReason()) && Objects.equals(this.creationDateTime(), other.creationDateTime()) && Objects.equals(this.startDateTime(), other.startDateTime()) && Objects.equals(this.readyDateTime(), other.readyDateTime()) && Objects.equals(this.endDateTime(), other.endDateTime());
    }

    public String toString() {
        return ToString.builder((String)"InstanceGroupDetail").add("InstanceGroupId", (Object)this.instanceGroupId()).add("Name", (Object)this.name()).add("Market", (Object)this.marketString()).add("InstanceRole", (Object)this.instanceRoleString()).add("BidPrice", (Object)this.bidPrice()).add("InstanceType", (Object)this.instanceType()).add("InstanceRequestCount", (Object)this.instanceRequestCount()).add("InstanceRunningCount", (Object)this.instanceRunningCount()).add("State", (Object)this.stateString()).add("LastStateChangeReason", (Object)this.lastStateChangeReason()).add("CreationDateTime", (Object)this.creationDateTime()).add("StartDateTime", (Object)this.startDateTime()).add("ReadyDateTime", (Object)this.readyDateTime()).add("EndDateTime", (Object)this.endDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceGroupId": {
                return Optional.of(clazz.cast(this.instanceGroupId()));
            }
            case "Name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "Market": {
                return Optional.of(clazz.cast(this.marketString()));
            }
            case "InstanceRole": {
                return Optional.of(clazz.cast(this.instanceRoleString()));
            }
            case "BidPrice": {
                return Optional.of(clazz.cast(this.bidPrice()));
            }
            case "InstanceType": {
                return Optional.of(clazz.cast(this.instanceType()));
            }
            case "InstanceRequestCount": {
                return Optional.of(clazz.cast(this.instanceRequestCount()));
            }
            case "InstanceRunningCount": {
                return Optional.of(clazz.cast(this.instanceRunningCount()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "LastStateChangeReason": {
                return Optional.of(clazz.cast(this.lastStateChangeReason()));
            }
            case "CreationDateTime": {
                return Optional.of(clazz.cast(this.creationDateTime()));
            }
            case "StartDateTime": {
                return Optional.of(clazz.cast(this.startDateTime()));
            }
            case "ReadyDateTime": {
                return Optional.of(clazz.cast(this.readyDateTime()));
            }
            case "EndDateTime": {
                return Optional.of(clazz.cast(this.endDateTime()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceGroupDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceGroupId;
        private String name;
        private String market;
        private String instanceRole;
        private String bidPrice;
        private String instanceType;
        private Integer instanceRequestCount;
        private Integer instanceRunningCount;
        private String state;
        private String lastStateChangeReason;
        private Instant creationDateTime;
        private Instant startDateTime;
        private Instant readyDateTime;
        private Instant endDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceGroupDetail model) {
            this.instanceGroupId(model.instanceGroupId);
            this.name(model.name);
            this.market(model.market);
            this.instanceRole(model.instanceRole);
            this.bidPrice(model.bidPrice);
            this.instanceType(model.instanceType);
            this.instanceRequestCount(model.instanceRequestCount);
            this.instanceRunningCount(model.instanceRunningCount);
            this.state(model.state);
            this.lastStateChangeReason(model.lastStateChangeReason);
            this.creationDateTime(model.creationDateTime);
            this.startDateTime(model.startDateTime);
            this.readyDateTime(model.readyDateTime);
            this.endDateTime(model.endDateTime);
        }

        public final String getInstanceGroupId() {
            return this.instanceGroupId;
        }

        @Override
        public final Builder instanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
            return this;
        }

        public final void setInstanceGroupId(String instanceGroupId) {
            this.instanceGroupId = instanceGroupId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getMarket() {
            return this.market;
        }

        @Override
        public final Builder market(String market) {
            this.market = market;
            return this;
        }

        @Override
        public final Builder market(MarketType market) {
            this.market(market.toString());
            return this;
        }

        public final void setMarket(String market) {
            this.market = market;
        }

        public final String getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        @Override
        public final Builder instanceRole(InstanceRoleType instanceRole) {
            this.instanceRole(instanceRole.toString());
            return this;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        public final String getBidPrice() {
            return this.bidPrice;
        }

        @Override
        public final Builder bidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
            return this;
        }

        public final void setBidPrice(String bidPrice) {
            this.bidPrice = bidPrice;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getInstanceRequestCount() {
            return this.instanceRequestCount;
        }

        @Override
        public final Builder instanceRequestCount(Integer instanceRequestCount) {
            this.instanceRequestCount = instanceRequestCount;
            return this;
        }

        public final void setInstanceRequestCount(Integer instanceRequestCount) {
            this.instanceRequestCount = instanceRequestCount;
        }

        public final Integer getInstanceRunningCount() {
            return this.instanceRunningCount;
        }

        @Override
        public final Builder instanceRunningCount(Integer instanceRunningCount) {
            this.instanceRunningCount = instanceRunningCount;
            return this;
        }

        public final void setInstanceRunningCount(Integer instanceRunningCount) {
            this.instanceRunningCount = instanceRunningCount;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(InstanceGroupState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getLastStateChangeReason() {
            return this.lastStateChangeReason;
        }

        @Override
        public final Builder lastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
            return this;
        }

        public final void setLastStateChangeReason(String lastStateChangeReason) {
            this.lastStateChangeReason = lastStateChangeReason;
        }

        public final Instant getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public final Builder creationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
            return this;
        }

        public final void setCreationDateTime(Instant creationDateTime) {
            this.creationDateTime = creationDateTime;
        }

        public final Instant getStartDateTime() {
            return this.startDateTime;
        }

        @Override
        public final Builder startDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
            return this;
        }

        public final void setStartDateTime(Instant startDateTime) {
            this.startDateTime = startDateTime;
        }

        public final Instant getReadyDateTime() {
            return this.readyDateTime;
        }

        @Override
        public final Builder readyDateTime(Instant readyDateTime) {
            this.readyDateTime = readyDateTime;
            return this;
        }

        public final void setReadyDateTime(Instant readyDateTime) {
            this.readyDateTime = readyDateTime;
        }

        public final Instant getEndDateTime() {
            return this.endDateTime;
        }

        @Override
        public final Builder endDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
            return this;
        }

        public final void setEndDateTime(Instant endDateTime) {
            this.endDateTime = endDateTime;
        }

        public InstanceGroupDetail build() {
            return new InstanceGroupDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InstanceGroupDetail> {
        public Builder instanceGroupId(String var1);

        public Builder name(String var1);

        public Builder market(String var1);

        public Builder market(MarketType var1);

        public Builder instanceRole(String var1);

        public Builder instanceRole(InstanceRoleType var1);

        public Builder bidPrice(String var1);

        public Builder instanceType(String var1);

        public Builder instanceRequestCount(Integer var1);

        public Builder instanceRunningCount(Integer var1);

        public Builder state(String var1);

        public Builder state(InstanceGroupState var1);

        public Builder lastStateChangeReason(String var1);

        public Builder creationDateTime(Instant var1);

        public Builder startDateTime(Instant var1);

        public Builder readyDateTime(Instant var1);

        public Builder endDateTime(Instant var1);
    }
}

