/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.StepTimeline;

@SdkInternalApi
public class StepTimelineMarshaller {
    private static final MarshallingInfo<Instant> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDateTime").build();
    private static final MarshallingInfo<Instant> STARTDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartDateTime").build();
    private static final MarshallingInfo<Instant> ENDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndDateTime").build();
    private static final StepTimelineMarshaller INSTANCE = new StepTimelineMarshaller();

    public static StepTimelineMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(StepTimeline stepTimeline, ProtocolMarshaller protocolMarshaller) {
        if (stepTimeline == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)stepTimeline.creationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)stepTimeline.startDateTime(), STARTDATETIME_BINDING);
            protocolMarshaller.marshall((Object)stepTimeline.endDateTime(), ENDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

