/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.emr.model.StepConfig;
import software.amazon.awssdk.services.emr.transform.HadoopJarStepConfigUnmarshaller;

public class StepConfigUnmarshaller
implements Unmarshaller<StepConfig, JsonUnmarshallerContext> {
    private static final StepConfigUnmarshaller INSTANCE = new StepConfigUnmarshaller();

    public StepConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        StepConfig.Builder stepConfigBuilder = StepConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Name", targetDepth)) {
                    context.nextToken();
                    stepConfigBuilder.name((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ActionOnFailure", targetDepth)) {
                    context.nextToken();
                    stepConfigBuilder.actionOnFailure((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("HadoopJarStep", targetDepth)) {
                    context.nextToken();
                    stepConfigBuilder.hadoopJarStep(HadoopJarStepConfigUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (StepConfig)stepConfigBuilder.build();
    }

    public static StepConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

