/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.emr.EMRClient;
import software.amazon.awssdk.services.emr.model.ListStepsRequest;
import software.amazon.awssdk.services.emr.model.ListStepsResponse;
import software.amazon.awssdk.services.emr.model.StepSummary;

public final class ListStepsPaginator
implements SdkIterable<ListStepsResponse> {
    private final EMRClient client;
    private final ListStepsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListStepsPaginator(EMRClient client, ListStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStepsResponseFetcher();
    }

    public Iterator<ListStepsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<StepSummary> steps() {
        Function<ListStepsResponse, Iterator> getIterator = response -> response != null ? response.steps().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListStepsResponseFetcher
    implements NextPageFetcher<ListStepsResponse> {
        private ListStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListStepsResponse previousPage) {
            return previousPage.marker() != null;
        }

        public ListStepsResponse nextPage(ListStepsResponse previousPage) {
            if (previousPage == null) {
                return ListStepsPaginator.this.client.listSteps(ListStepsPaginator.this.firstRequest);
            }
            return ListStepsPaginator.this.client.listSteps((ListStepsRequest)((Object)ListStepsPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

