/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.emr.model.EMRRequest;
import software.amazon.awssdk.services.emr.model.InstanceFleetConfig;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AddInstanceFleetRequest
extends EMRRequest
implements ToCopyableBuilder<Builder, AddInstanceFleetRequest> {
    private final String clusterId;
    private final InstanceFleetConfig instanceFleet;

    private AddInstanceFleetRequest(BuilderImpl builder) {
        super(builder);
        this.clusterId = builder.clusterId;
        this.instanceFleet = builder.instanceFleet;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public InstanceFleetConfig instanceFleet() {
        return this.instanceFleet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceFleet());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddInstanceFleetRequest)) {
            return false;
        }
        AddInstanceFleetRequest other = (AddInstanceFleetRequest)((Object)obj);
        return Objects.equals(this.clusterId(), other.clusterId()) && Objects.equals(this.instanceFleet(), other.instanceFleet());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterId() != null) {
            sb.append("ClusterId: ").append(this.clusterId()).append(",");
        }
        if (this.instanceFleet() != null) {
            sb.append("InstanceFleet: ").append(this.instanceFleet()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterId": {
                return Optional.of(clazz.cast(this.clusterId()));
            }
            case "InstanceFleet": {
                return Optional.of(clazz.cast(this.instanceFleet()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends EMRRequest.BuilderImpl
    implements Builder {
        private String clusterId;
        private InstanceFleetConfig instanceFleet;

        private BuilderImpl() {
        }

        private BuilderImpl(AddInstanceFleetRequest model) {
            this.clusterId(model.clusterId);
            this.instanceFleet(model.instanceFleet);
        }

        public final String getClusterId() {
            return this.clusterId;
        }

        @Override
        public final Builder clusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public final void setClusterId(String clusterId) {
            this.clusterId = clusterId;
        }

        public final InstanceFleetConfig.Builder getInstanceFleet() {
            return this.instanceFleet != null ? this.instanceFleet.toBuilder() : null;
        }

        @Override
        public final Builder instanceFleet(InstanceFleetConfig instanceFleet) {
            this.instanceFleet = instanceFleet;
            return this;
        }

        public final void setInstanceFleet(InstanceFleetConfig.BuilderImpl instanceFleet) {
            this.instanceFleet = instanceFleet != null ? instanceFleet.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public AddInstanceFleetRequest build() {
            return new AddInstanceFleetRequest(this);
        }
    }

    public static interface Builder
    extends EMRRequest.Builder,
    CopyableBuilder<Builder, AddInstanceFleetRequest> {
        public Builder clusterId(String var1);

        public Builder instanceFleet(InstanceFleetConfig var1);

        default public Builder instanceFleet(Consumer<InstanceFleetConfig.Builder> instanceFleet) {
            return this.instanceFleet((InstanceFleetConfig)((InstanceFleetConfig.Builder)InstanceFleetConfig.builder().apply(instanceFleet)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

