/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.time.Instant;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.SecurityConfigurationSummary;

@SdkInternalApi
public class SecurityConfigurationSummaryMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<Instant> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDateTime").build();
    private static final SecurityConfigurationSummaryMarshaller INSTANCE = new SecurityConfigurationSummaryMarshaller();

    public static SecurityConfigurationSummaryMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SecurityConfigurationSummary securityConfigurationSummary, ProtocolMarshaller protocolMarshaller) {
        if (securityConfigurationSummary == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)securityConfigurationSummary.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)securityConfigurationSummary.creationDateTime(), CREATIONDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

