/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.emr.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.emr.model.ListStepsRequest;

@SdkInternalApi
public class ListStepsRequestModelMarshaller {
    private static final MarshallingInfo<String> CLUSTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ClusterId").build();
    private static final MarshallingInfo<List> STEPSTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepStates").build();
    private static final MarshallingInfo<List> STEPIDS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StepIds").build();
    private static final MarshallingInfo<String> MARKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Marker").build();
    private static final ListStepsRequestModelMarshaller INSTANCE = new ListStepsRequestModelMarshaller();

    public static ListStepsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListStepsRequest listStepsRequest, ProtocolMarshaller protocolMarshaller) {
        if (listStepsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)listStepsRequest.clusterId(), CLUSTERID_BINDING);
            protocolMarshaller.marshall(listStepsRequest.stepStatesStrings(), STEPSTATES_BINDING);
            protocolMarshaller.marshall(listStepsRequest.stepIds(), STEPIDS_BINDING);
            protocolMarshaller.marshall((Object)listStepsRequest.marker(), MARKER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

